// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.HybridCompute.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HybridCompute
{
    public partial class HybridComputeLicenseProfileData : IUtf8JsonSerializable, IJsonModel<HybridComputeLicenseProfileData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HybridComputeLicenseProfileData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HybridComputeLicenseProfileData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseProfileData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HybridComputeLicenseProfileData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ProvisioningState))
            {
                writer.WritePropertyName("provisioningState"u8);
                writer.WriteStringValue(ProvisioningState.Value.ToString());
            }
            writer.WritePropertyName("productProfile"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(SubscriptionStatus))
            {
                writer.WritePropertyName("subscriptionStatus"u8);
                writer.WriteStringValue(SubscriptionStatus.Value.ToString());
            }
            if (Optional.IsDefined(ProductType))
            {
                writer.WritePropertyName("productType"u8);
                writer.WriteStringValue(ProductType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(EnrollmentOn))
            {
                writer.WritePropertyName("enrollmentDate"u8);
                writer.WriteStringValue(EnrollmentOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(BillingStartOn))
            {
                writer.WritePropertyName("billingStartDate"u8);
                writer.WriteStringValue(BillingStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(DisenrollmentOn))
            {
                writer.WritePropertyName("disenrollmentDate"u8);
                writer.WriteStringValue(DisenrollmentOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(BillingEndOn))
            {
                writer.WritePropertyName("billingEndDate"u8);
                writer.WriteStringValue(BillingEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(Error))
            {
                writer.WritePropertyName("error"u8);
                JsonSerializer.Serialize(writer, Error);
            }
            if (Optional.IsCollectionDefined(ProductFeatures))
            {
                writer.WritePropertyName("productFeatures"u8);
                writer.WriteStartArray();
                foreach (var item in ProductFeatures)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
            writer.WritePropertyName("esuProfile"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(AssignedLicenseImmutableId))
            {
                writer.WritePropertyName("assignedLicenseImmutableId"u8);
                writer.WriteStringValue(AssignedLicenseImmutableId.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(EsuKeys))
            {
                writer.WritePropertyName("esuKeys"u8);
                writer.WriteStartArray();
                foreach (var item in EsuKeys)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ServerType))
            {
                writer.WritePropertyName("serverType"u8);
                writer.WriteStringValue(ServerType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(EsuEligibility))
            {
                writer.WritePropertyName("esuEligibility"u8);
                writer.WriteStringValue(EsuEligibility.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(EsuKeyState))
            {
                writer.WritePropertyName("esuKeyState"u8);
                writer.WriteStringValue(EsuKeyState.Value.ToString());
            }
            if (Optional.IsDefined(AssignedLicense))
            {
                writer.WritePropertyName("assignedLicense"u8);
                writer.WriteStringValue(AssignedLicense);
            }
            writer.WriteEndObject();
            writer.WritePropertyName("softwareAssurance"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(SoftwareAssuranceCustomer))
            {
                writer.WritePropertyName("softwareAssuranceCustomer"u8);
                writer.WriteBooleanValue(SoftwareAssuranceCustomer.Value);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        HybridComputeLicenseProfileData IJsonModel<HybridComputeLicenseProfileData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseProfileData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HybridComputeLicenseProfileData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHybridComputeLicenseProfileData(document.RootElement, options);
        }

        internal static HybridComputeLicenseProfileData DeserializeHybridComputeLicenseProfileData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            AzureLocation location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            HybridComputeProvisioningState? provisioningState = default;
            LicenseProfileSubscriptionStatus? subscriptionStatus = default;
            LicenseProfileProductType? productType = default;
            DateTimeOffset? enrollmentDate = default;
            DateTimeOffset? billingStartDate = default;
            DateTimeOffset? disenrollmentDate = default;
            DateTimeOffset? billingEndDate = default;
            ResponseError error = default;
            IList<HybridComputeProductFeature> productFeatures = default;
            Guid? assignedLicenseImmutableId = default;
            IReadOnlyList<EsuKey> esuKeys = default;
            EsuServerType? serverType = default;
            EsuEligibility? esuEligibility = default;
            EsuKeyState? esuKeyState = default;
            string assignedLicense = default;
            bool? softwareAssuranceCustomer = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("provisioningState"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            provisioningState = new HybridComputeProvisioningState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("productProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("subscriptionStatus"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    subscriptionStatus = new LicenseProfileSubscriptionStatus(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("productType"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    productType = new LicenseProfileProductType(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("enrollmentDate"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    enrollmentDate = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("billingStartDate"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    billingStartDate = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("disenrollmentDate"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    disenrollmentDate = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("billingEndDate"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    billingEndDate = property1.Value.GetDateTimeOffset("O");
                                    continue;
                                }
                                if (property1.NameEquals("error"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    error = JsonSerializer.Deserialize<ResponseError>(property1.Value.GetRawText());
                                    continue;
                                }
                                if (property1.NameEquals("productFeatures"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    List<HybridComputeProductFeature> array = new List<HybridComputeProductFeature>();
                                    foreach (var item in property1.Value.EnumerateArray())
                                    {
                                        array.Add(HybridComputeProductFeature.DeserializeHybridComputeProductFeature(item, options));
                                    }
                                    productFeatures = array;
                                    continue;
                                }
                            }
                            continue;
                        }
                        if (property0.NameEquals("esuProfile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("assignedLicenseImmutableId"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    assignedLicenseImmutableId = property1.Value.GetGuid();
                                    continue;
                                }
                                if (property1.NameEquals("esuKeys"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    List<EsuKey> array = new List<EsuKey>();
                                    foreach (var item in property1.Value.EnumerateArray())
                                    {
                                        array.Add(EsuKey.DeserializeEsuKey(item, options));
                                    }
                                    esuKeys = array;
                                    continue;
                                }
                                if (property1.NameEquals("serverType"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    serverType = new EsuServerType(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("esuEligibility"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    esuEligibility = new EsuEligibility(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("esuKeyState"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    esuKeyState = new EsuKeyState(property1.Value.GetString());
                                    continue;
                                }
                                if (property1.NameEquals("assignedLicense"u8))
                                {
                                    assignedLicense = property1.Value.GetString();
                                    continue;
                                }
                            }
                            continue;
                        }
                        if (property0.NameEquals("softwareAssurance"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                property0.ThrowNonNullablePropertyIsNull();
                                continue;
                            }
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.NameEquals("softwareAssuranceCustomer"u8))
                                {
                                    if (property1.Value.ValueKind == JsonValueKind.Null)
                                    {
                                        continue;
                                    }
                                    softwareAssuranceCustomer = property1.Value.GetBoolean();
                                    continue;
                                }
                            }
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HybridComputeLicenseProfileData(
                id,
                name,
                type,
                systemData,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                location,
                provisioningState,
                subscriptionStatus,
                productType,
                enrollmentDate,
                billingStartDate,
                disenrollmentDate,
                billingEndDate,
                error,
                productFeatures ?? new ChangeTrackingList<HybridComputeProductFeature>(),
                assignedLicenseImmutableId,
                esuKeys ?? new ChangeTrackingList<EsuKey>(),
                serverType,
                esuEligibility,
                esuKeyState,
                assignedLicense,
                softwareAssuranceCustomer,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                builder.Append("  location: ");
                builder.AppendLine($"'{Location.ToString()}'");
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProvisioningState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    provisioningState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProvisioningState))
                {
                    builder.Append("    provisioningState: ");
                    builder.AppendLine($"'{ProvisioningState.Value.ToString()}'");
                }
            }

            builder.Append("    productProfile:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SubscriptionStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      subscriptionStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SubscriptionStatus))
                {
                    builder.Append("      subscriptionStatus: ");
                    builder.AppendLine($"'{SubscriptionStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProductType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      productType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ProductType))
                {
                    builder.Append("      productType: ");
                    builder.AppendLine($"'{ProductType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnrollmentOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      enrollmentDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnrollmentOn))
                {
                    builder.Append("      enrollmentDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(EnrollmentOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      billingStartDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingStartOn))
                {
                    builder.Append("      billingStartDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(BillingStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisenrollmentOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      disenrollmentDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisenrollmentOn))
                {
                    builder.Append("      disenrollmentDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(DisenrollmentOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(BillingEndOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      billingEndDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(BillingEndOn))
                {
                    builder.Append("      billingEndDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(BillingEndOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Error), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      error: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Error))
                {
                    builder.Append("      error: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Error, options, 6, false, "      error: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ProductFeatures), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      productFeatures: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ProductFeatures))
                {
                    if (ProductFeatures.Any())
                    {
                        builder.Append("      productFeatures: ");
                        builder.AppendLine("[");
                        foreach (var item in ProductFeatures)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 8, true, "      productFeatures: ");
                        }
                        builder.AppendLine("      ]");
                    }
                }
            }

            builder.AppendLine("    }");
            builder.Append("    esuProfile:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AssignedLicenseImmutableId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      assignedLicenseImmutableId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AssignedLicenseImmutableId))
                {
                    builder.Append("      assignedLicenseImmutableId: ");
                    builder.AppendLine($"'{AssignedLicenseImmutableId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EsuKeys), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      esuKeys: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(EsuKeys))
                {
                    if (EsuKeys.Any())
                    {
                        builder.Append("      esuKeys: ");
                        builder.AppendLine("[");
                        foreach (var item in EsuKeys)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 8, true, "      esuKeys: ");
                        }
                        builder.AppendLine("      ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ServerType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      serverType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ServerType))
                {
                    builder.Append("      serverType: ");
                    builder.AppendLine($"'{ServerType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EsuEligibility), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      esuEligibility: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EsuEligibility))
                {
                    builder.Append("      esuEligibility: ");
                    builder.AppendLine($"'{EsuEligibility.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EsuKeyState), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      esuKeyState: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EsuKeyState))
                {
                    builder.Append("      esuKeyState: ");
                    builder.AppendLine($"'{EsuKeyState.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AssignedLicense), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      assignedLicense: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AssignedLicense))
                {
                    builder.Append("      assignedLicense: ");
                    if (AssignedLicense.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AssignedLicense}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AssignedLicense}'");
                    }
                }
            }

            builder.AppendLine("    }");
            builder.Append("    softwareAssurance:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SoftwareAssuranceCustomer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("      softwareAssuranceCustomer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SoftwareAssuranceCustomer))
                {
                    builder.Append("      softwareAssuranceCustomer: ");
                    var boolValue = SoftwareAssuranceCustomer.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("    }");
            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HybridComputeLicenseProfileData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseProfileData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HybridComputeLicenseProfileData)} does not support writing '{options.Format}' format.");
            }
        }

        HybridComputeLicenseProfileData IPersistableModel<HybridComputeLicenseProfileData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HybridComputeLicenseProfileData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHybridComputeLicenseProfileData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HybridComputeLicenseProfileData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HybridComputeLicenseProfileData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
