// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.HybridCompute.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HybridCompute
{
    /// <summary>
    /// A class representing the HybridComputeLicense data model.
    /// Describes a license in a hybrid machine.
    /// </summary>
    public partial class HybridComputeLicenseData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseData"/>. </summary>
        /// <param name="location"> The location. </param>
        public HybridComputeLicenseData(AzureLocation location) : base(location)
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="tenantId"> Describes the tenant id. </param>
        /// <param name="licenseType"> The type of the license resource. </param>
        /// <param name="licenseDetails"> Describes the properties of a License. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeLicenseData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, HybridComputeProvisioningState? provisioningState, Guid? tenantId, HybridComputeLicenseType? licenseType, HybridComputeLicenseDetails licenseDetails, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ProvisioningState = provisioningState;
            TenantId = tenantId;
            LicenseType = licenseType;
            LicenseDetails = licenseDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeLicenseData"/> for deserialization. </summary>
        internal HybridComputeLicenseData()
        {
        }

        /// <summary> The provisioning state, which only appears in the response. </summary>
        [WirePath("properties.provisioningState")]
        public HybridComputeProvisioningState? ProvisioningState { get; }
        /// <summary> Describes the tenant id. </summary>
        [WirePath("properties.tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> The type of the license resource. </summary>
        [WirePath("properties.licenseType")]
        public HybridComputeLicenseType? LicenseType { get; set; }
        /// <summary> Describes the properties of a License. </summary>
        [WirePath("properties.licenseDetails")]
        public HybridComputeLicenseDetails LicenseDetails { get; set; }
    }
}
