// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.HybridCompute
{
    /// <summary>
    /// A class representing a collection of <see cref="HybridComputeLicenseResource"/> and their operations.
    /// Each <see cref="HybridComputeLicenseResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="HybridComputeLicenseCollection"/> instance call the GetHybridComputeLicenses method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class HybridComputeLicenseCollection : ArmCollection, IEnumerable<HybridComputeLicenseResource>, IAsyncEnumerable<HybridComputeLicenseResource>
    {
        private readonly ClientDiagnostics _hybridComputeLicenseLicensesClientDiagnostics;
        private readonly LicensesRestOperations _hybridComputeLicenseLicensesRestClient;

        /// <summary> Initializes a new instance of the <see cref="HybridComputeLicenseCollection"/> class for mocking. </summary>
        protected HybridComputeLicenseCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="HybridComputeLicenseCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal HybridComputeLicenseCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _hybridComputeLicenseLicensesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.HybridCompute", HybridComputeLicenseResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(HybridComputeLicenseResource.ResourceType, out string hybridComputeLicenseLicensesApiVersion);
            _hybridComputeLicenseLicensesRestClient = new LicensesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, hybridComputeLicenseLicensesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// The operation to create or update a license.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="data"> Parameters supplied to the Create license operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<HybridComputeLicenseResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string licenseName, HybridComputeLicenseData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _hybridComputeLicenseLicensesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, licenseName, data, cancellationToken).ConfigureAwait(false);
                var operation = new HybridComputeArmOperation<HybridComputeLicenseResource>(new HybridComputeLicenseOperationSource(Client), _hybridComputeLicenseLicensesClientDiagnostics, Pipeline, _hybridComputeLicenseLicensesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, licenseName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to create or update a license.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="data"> Parameters supplied to the Create license operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<HybridComputeLicenseResource> CreateOrUpdate(WaitUntil waitUntil, string licenseName, HybridComputeLicenseData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _hybridComputeLicenseLicensesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, licenseName, data, cancellationToken);
                var operation = new HybridComputeArmOperation<HybridComputeLicenseResource>(new HybridComputeLicenseOperationSource(Client), _hybridComputeLicenseLicensesClientDiagnostics, Pipeline, _hybridComputeLicenseLicensesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, licenseName, data).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieves information about the view of a license.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> is null. </exception>
        public virtual async Task<Response<HybridComputeLicenseResource>> GetAsync(string licenseName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.Get");
            scope.Start();
            try
            {
                var response = await _hybridComputeLicenseLicensesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, licenseName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HybridComputeLicenseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieves information about the view of a license.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> is null. </exception>
        public virtual Response<HybridComputeLicenseResource> Get(string licenseName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.Get");
            scope.Start();
            try
            {
                var response = _hybridComputeLicenseLicensesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, licenseName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new HybridComputeLicenseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to get all licenses of a non-Azure machine
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="HybridComputeLicenseResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<HybridComputeLicenseResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _hybridComputeLicenseLicensesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _hybridComputeLicenseLicensesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new HybridComputeLicenseResource(Client, HybridComputeLicenseData.DeserializeHybridComputeLicenseData(e)), _hybridComputeLicenseLicensesClientDiagnostics, Pipeline, "HybridComputeLicenseCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// The operation to get all licenses of a non-Azure machine
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_ListByResourceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="HybridComputeLicenseResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<HybridComputeLicenseResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _hybridComputeLicenseLicensesRestClient.CreateListByResourceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _hybridComputeLicenseLicensesRestClient.CreateListByResourceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new HybridComputeLicenseResource(Client, HybridComputeLicenseData.DeserializeHybridComputeLicenseData(e)), _hybridComputeLicenseLicensesClientDiagnostics, Pipeline, "HybridComputeLicenseCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string licenseName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.Exists");
            scope.Start();
            try
            {
                var response = await _hybridComputeLicenseLicensesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, licenseName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> is null. </exception>
        public virtual Response<bool> Exists(string licenseName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.Exists");
            scope.Start();
            try
            {
                var response = _hybridComputeLicenseLicensesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, licenseName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> is null. </exception>
        public virtual async Task<NullableResponse<HybridComputeLicenseResource>> GetIfExistsAsync(string licenseName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _hybridComputeLicenseLicensesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, licenseName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<HybridComputeLicenseResource>(response.GetRawResponse());
                return Response.FromValue(new HybridComputeLicenseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/licenses/{licenseName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Licenses_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-07-10</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="HybridComputeLicenseResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="licenseName"> The name of the license. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="licenseName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="licenseName"/> is null. </exception>
        public virtual NullableResponse<HybridComputeLicenseResource> GetIfExists(string licenseName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(licenseName, nameof(licenseName));

            using var scope = _hybridComputeLicenseLicensesClientDiagnostics.CreateScope("HybridComputeLicenseCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _hybridComputeLicenseLicensesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, licenseName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<HybridComputeLicenseResource>(response.GetRawResponse());
                return Response.FromValue(new HybridComputeLicenseResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<HybridComputeLicenseResource> IEnumerable<HybridComputeLicenseResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<HybridComputeLicenseResource> IAsyncEnumerable<HybridComputeLicenseResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
