// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HybridCompute
{
    /// <summary>
    /// A class representing the HybridComputeExtensionValue data model.
    /// Describes a Extension Metadata
    /// </summary>
    public partial class HybridComputeExtensionValueData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridComputeExtensionValueData"/>. </summary>
        internal HybridComputeExtensionValueData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridComputeExtensionValueData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="version"> The version of the Extension being received. </param>
        /// <param name="extensionType"> The type of the Extension being received. </param>
        /// <param name="publisher"> The publisher of the Extension being received. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridComputeExtensionValueData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string version, string extensionType, string publisher, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Version = version;
            ExtensionType = extensionType;
            Publisher = publisher;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The version of the Extension being received. </summary>
        [WirePath("properties.version")]
        public string Version { get; }
        /// <summary> The type of the Extension being received. </summary>
        [WirePath("properties.extensionType")]
        public string ExtensionType { get; }
        /// <summary> The publisher of the Extension being received. </summary>
        [WirePath("properties.publisher")]
        public string Publisher { get; }
    }
}
