// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.HybridCompute.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmHybridComputeModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputeLicenseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="tenantId"> Describes the tenant id. </param>
        /// <param name="licenseType"> The type of the license resource. </param>
        /// <param name="licenseDetails"> Describes the properties of a License. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputeLicenseData"/> instance for mocking. </returns>
        public static HybridComputeLicenseData HybridComputeLicenseData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, HybridComputeProvisioningState? provisioningState = null, Guid? tenantId = null, HybridComputeLicenseType? licenseType = null, HybridComputeLicenseDetails licenseDetails = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HybridComputeLicenseData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                tenantId,
                licenseType,
                licenseDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeLicenseDetails"/>. </summary>
        /// <param name="state"> Describes the state of the license. </param>
        /// <param name="target"> Describes the license target server. </param>
        /// <param name="edition"> Describes the edition of the license. The values are either Standard or Datacenter. </param>
        /// <param name="licenseCoreType"> Describes the license core type (pCore or vCore). </param>
        /// <param name="processors"> Describes the number of processors. </param>
        /// <param name="assignedLicenses"> Describes the number of assigned licenses. </param>
        /// <param name="immutableId"> Describes the immutable id. </param>
        /// <param name="volumeLicenseDetails"> A list of volume license details. </param>
        /// <returns> A new <see cref="Models.HybridComputeLicenseDetails"/> instance for mocking. </returns>
        public static HybridComputeLicenseDetails HybridComputeLicenseDetails(HybridComputeLicenseState? state = null, HybridComputeLicenseTarget? target = null, HybridComputeLicenseEdition? edition = null, LicenseCoreType? licenseCoreType = null, int? processors = null, int? assignedLicenses = null, string immutableId = null, IEnumerable<VolumeLicenseDetails> volumeLicenseDetails = null)
        {
            volumeLicenseDetails ??= new List<VolumeLicenseDetails>();

            return new HybridComputeLicenseDetails(
                state,
                target,
                edition,
                licenseCoreType,
                processors,
                assignedLicenses,
                immutableId,
                volumeLicenseDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputeMachineData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="resources"> The list of extensions affiliated to the machine. </param>
        /// <param name="identity"> Identity for the resource. Current supported identity types: SystemAssigned. </param>
        /// <param name="kind"> Indicates which kind of Arc machine placement on-premises, such as HCI, SCVMM or VMware etc. </param>
        /// <param name="locationData"> Metadata pertaining to the geographic location of the resource. </param>
        /// <param name="agentConfiguration"> Configurable properties that the user can set locally via the azcmagent config command, or remotely via ARM. </param>
        /// <param name="serviceStatuses"> Statuses of dependent services that are reported back to ARM. </param>
        /// <param name="cloudMetadataProvider"> The metadata of the cloud environment (Azure/GCP/AWS/OCI...). </param>
        /// <param name="agentUpgrade"> The info of the machine w.r.t Agent Upgrade. </param>
        /// <param name="osProfile"> Specifies the operating system settings for the hybrid machine. </param>
        /// <param name="licenseProfile"> Specifies the License related properties for a machine. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="status"> The status of the hybrid machine agent. </param>
        /// <param name="lastStatusChange"> The time of the last status change. </param>
        /// <param name="errorDetails"> Details about the error state. </param>
        /// <param name="agentVersion"> The hybrid machine agent full version. </param>
        /// <param name="vmId"> Specifies the hybrid machine unique ID. </param>
        /// <param name="displayName"> Specifies the hybrid machine display name. </param>
        /// <param name="machineFqdn"> Specifies the hybrid machine FQDN. </param>
        /// <param name="clientPublicKey"> Public Key that the client provides to be used during initial resource onboarding. </param>
        /// <param name="osName"> The Operating System running on the hybrid machine. </param>
        /// <param name="osVersion"> The version of Operating System running on the hybrid machine. </param>
        /// <param name="osType"> The type of Operating System (windows/linux). </param>
        /// <param name="vmUuid"> Specifies the Arc Machine's unique SMBIOS ID. </param>
        /// <param name="extensions"> Machine Extensions information (deprecated field). </param>
        /// <param name="osSku"> Specifies the Operating System product SKU. </param>
        /// <param name="osEdition"> The edition of the Operating System. </param>
        /// <param name="domainName"> Specifies the Windows domain name. </param>
        /// <param name="adFqdn"> Specifies the AD fully qualified display name. </param>
        /// <param name="dnsFqdn"> Specifies the DNS fully qualified display name. </param>
        /// <param name="privateLinkScopeResourceId"> The resource id of the private link scope this machine is assigned to, if any. </param>
        /// <param name="parentClusterResourceId"> The resource id of the parent cluster (Azure HCI) this machine is assigned to, if any. </param>
        /// <param name="msSqlDiscovered"> Specifies whether any MS SQL instance is discovered on the machine. </param>
        /// <param name="detectedProperties"> Detected properties from the machine. </param>
        /// <param name="networkInterfaces"> Information about the network the machine is on. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputeMachineData"/> instance for mocking. </returns>
        public static HybridComputeMachineData HybridComputeMachineData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<HybridComputeMachineExtensionData> resources = null, ManagedServiceIdentity identity = null, ArcKindEnum? kind = null, HybridComputeLocation locationData = null, AgentConfiguration agentConfiguration = null, HybridComputeServiceStatuses serviceStatuses = null, string cloudMetadataProvider = null, AgentUpgrade agentUpgrade = null, HybridComputeOSProfile osProfile = null, LicenseProfileMachineInstanceView licenseProfile = null, string provisioningState = null, HybridComputeStatusType? status = null, DateTimeOffset? lastStatusChange = null, IEnumerable<ResponseError> errorDetails = null, string agentVersion = null, Guid? vmId = null, string displayName = null, string machineFqdn = null, string clientPublicKey = null, string osName = null, string osVersion = null, string osType = null, Guid? vmUuid = null, IEnumerable<MachineExtensionInstanceView> extensions = null, string osSku = null, string osEdition = null, string domainName = null, string adFqdn = null, string dnsFqdn = null, ResourceIdentifier privateLinkScopeResourceId = null, ResourceIdentifier parentClusterResourceId = null, string msSqlDiscovered = null, IReadOnlyDictionary<string, string> detectedProperties = null, IEnumerable<HybridComputeNetworkInterface> networkInterfaces = null)
        {
            tags ??= new Dictionary<string, string>();
            resources ??= new List<HybridComputeMachineExtensionData>();
            errorDetails ??= new List<ResponseError>();
            extensions ??= new List<MachineExtensionInstanceView>();
            detectedProperties ??= new Dictionary<string, string>();
            networkInterfaces ??= new List<HybridComputeNetworkInterface>();

            return new HybridComputeMachineData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                resources?.ToList(),
                identity,
                kind,
                locationData,
                agentConfiguration,
                serviceStatuses,
                cloudMetadataProvider != null ? new HybridComputeCloudMetadata(cloudMetadataProvider, serializedAdditionalRawData: null) : null,
                agentUpgrade,
                osProfile,
                licenseProfile,
                provisioningState,
                status,
                lastStatusChange,
                errorDetails?.ToList(),
                agentVersion,
                vmId,
                displayName,
                machineFqdn,
                clientPublicKey,
                osName,
                osVersion,
                osType,
                vmUuid,
                extensions?.ToList(),
                osSku,
                osEdition,
                domainName,
                adFqdn,
                dnsFqdn,
                privateLinkScopeResourceId,
                parentClusterResourceId,
                msSqlDiscovered,
                detectedProperties,
                networkInterfaces != null ? new HybridComputeNetworkProfile(networkInterfaces?.ToList(), serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AgentConfiguration"/>. </summary>
        /// <param name="proxyUri"> Specifies the URL of the proxy to be used. </param>
        /// <param name="incomingConnectionsPorts"> Specifies the list of ports that the agent will be able to listen on. </param>
        /// <param name="extensionsAllowList"> Array of extensions that are allowed to be installed or updated. </param>
        /// <param name="extensionsBlockList"> Array of extensions that are blocked (cannot be installed or updated). </param>
        /// <param name="proxyBypass"> List of service names which should not use the specified proxy server. </param>
        /// <param name="extensionsEnabled"> Specifies whether the extension service is enabled or disabled. </param>
        /// <param name="guestConfigurationEnabled"> Specified whether the guest configuration service is enabled or disabled. </param>
        /// <param name="configMode"> Name of configuration mode to use. Modes are pre-defined configurations of security controls, extension allowlists and guest configuration, maintained by Microsoft. </param>
        /// <returns> A new <see cref="Models.AgentConfiguration"/> instance for mocking. </returns>
        public static AgentConfiguration AgentConfiguration(Uri proxyUri = null, IEnumerable<string> incomingConnectionsPorts = null, IEnumerable<HybridComputeConfigurationExtension> extensionsAllowList = null, IEnumerable<HybridComputeConfigurationExtension> extensionsBlockList = null, IEnumerable<string> proxyBypass = null, string extensionsEnabled = null, string guestConfigurationEnabled = null, AgentConfigurationMode? configMode = null)
        {
            incomingConnectionsPorts ??= new List<string>();
            extensionsAllowList ??= new List<HybridComputeConfigurationExtension>();
            extensionsBlockList ??= new List<HybridComputeConfigurationExtension>();
            proxyBypass ??= new List<string>();

            return new AgentConfiguration(
                proxyUri,
                incomingConnectionsPorts?.ToList(),
                extensionsAllowList?.ToList(),
                extensionsBlockList?.ToList(),
                proxyBypass?.ToList(),
                extensionsEnabled,
                guestConfigurationEnabled,
                configMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeConfigurationExtension"/>. </summary>
        /// <param name="publisher"> Publisher of the extension. </param>
        /// <param name="configurationExtensionType"> Type of the extension. </param>
        /// <returns> A new <see cref="Models.HybridComputeConfigurationExtension"/> instance for mocking. </returns>
        public static HybridComputeConfigurationExtension HybridComputeConfigurationExtension(string publisher = null, string configurationExtensionType = null)
        {
            return new HybridComputeConfigurationExtension(publisher, configurationExtensionType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AgentUpgrade"/>. </summary>
        /// <param name="desiredVersion"> Specifies the version info w.r.t AgentUpgrade for the machine. </param>
        /// <param name="correlationId"> The correlation ID passed in from RSM per upgrade. </param>
        /// <param name="isAutomaticUpgradeEnabled"> Specifies if RSM should try to upgrade this machine. </param>
        /// <param name="lastAttemptDesiredVersion"> Specifies the version of the last attempt. </param>
        /// <param name="lastAttemptedOn"> Timestamp of last upgrade attempt. </param>
        /// <param name="lastAttemptStatus"> Specifies the status of Agent Upgrade. </param>
        /// <param name="lastAttemptMessage"> Failure message of last upgrade attempt if any. </param>
        /// <returns> A new <see cref="Models.AgentUpgrade"/> instance for mocking. </returns>
        public static AgentUpgrade AgentUpgrade(string desiredVersion = null, Guid? correlationId = null, bool? isAutomaticUpgradeEnabled = null, string lastAttemptDesiredVersion = null, DateTimeOffset? lastAttemptedOn = null, LastAttemptStatusEnum? lastAttemptStatus = null, string lastAttemptMessage = null)
        {
            return new AgentUpgrade(
                desiredVersion,
                correlationId,
                isAutomaticUpgradeEnabled,
                lastAttemptDesiredVersion,
                lastAttemptedOn,
                lastAttemptStatus,
                lastAttemptMessage,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeOSProfile"/>. </summary>
        /// <param name="computerName"> Specifies the host OS name of the hybrid machine. </param>
        /// <param name="windowsConfiguration"> Specifies the windows configuration for update management. </param>
        /// <param name="linuxConfiguration"> Specifies the linux configuration for update management. </param>
        /// <returns> A new <see cref="Models.HybridComputeOSProfile"/> instance for mocking. </returns>
        public static HybridComputeOSProfile HybridComputeOSProfile(string computerName = null, HybridComputeWindowsConfiguration windowsConfiguration = null, HybridComputeLinuxConfiguration linuxConfiguration = null)
        {
            return new HybridComputeOSProfile(computerName, windowsConfiguration, linuxConfiguration, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeWindowsConfiguration"/>. </summary>
        /// <param name="assessmentMode"> Specifies the assessment mode. </param>
        /// <param name="patchMode"> Specifies the patch mode. </param>
        /// <param name="isHotpatchingEnabled"> Captures the hotpatch capability enrollment intent of the customers, which enables customers to patch their Windows machines without requiring a reboot. </param>
        /// <param name="status"> Status of the hotpatch capability enrollment or disenrollment. </param>
        /// <returns> A new <see cref="Models.HybridComputeWindowsConfiguration"/> instance for mocking. </returns>
        public static HybridComputeWindowsConfiguration HybridComputeWindowsConfiguration(AssessmentModeType? assessmentMode = null, PatchModeType? patchMode = null, bool? isHotpatchingEnabled = null, HybridComputePatchSettingsStatus status = null)
        {
            return new HybridComputeWindowsConfiguration(assessmentMode, patchMode, isHotpatchingEnabled, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputePatchSettingsStatus"/>. </summary>
        /// <param name="hotpatchEnablementStatus"> Indicates the current status of the hotpatch being enabled or disabled. </param>
        /// <param name="error"> The errors that were encountered during the hotpatch capability enrollment or disenrollment. </param>
        /// <returns> A new <see cref="Models.HybridComputePatchSettingsStatus"/> instance for mocking. </returns>
        public static HybridComputePatchSettingsStatus HybridComputePatchSettingsStatus(HotpatchEnablementStatus? hotpatchEnablementStatus = null, ResponseError error = null)
        {
            return new HybridComputePatchSettingsStatus(hotpatchEnablementStatus, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeLinuxConfiguration"/>. </summary>
        /// <param name="assessmentMode"> Specifies the assessment mode. </param>
        /// <param name="patchMode"> Specifies the patch mode. </param>
        /// <param name="isHotpatchingEnabled"> Captures the hotpatch capability enrollment intent of the customers, which enables customers to patch their Windows machines without requiring a reboot. </param>
        /// <param name="status"> Status of the hotpatch capability enrollment or disenrollment. </param>
        /// <returns> A new <see cref="Models.HybridComputeLinuxConfiguration"/> instance for mocking. </returns>
        public static HybridComputeLinuxConfiguration HybridComputeLinuxConfiguration(AssessmentModeType? assessmentMode = null, PatchModeType? patchMode = null, bool? isHotpatchingEnabled = null, HybridComputePatchSettingsStatus status = null)
        {
            return new HybridComputeLinuxConfiguration(assessmentMode, patchMode, isHotpatchingEnabled, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LicenseProfileMachineInstanceView"/>. </summary>
        /// <param name="licenseStatus"> Indicates the license status of the OS. </param>
        /// <param name="licenseChannel"> Indicates the license channel. </param>
        /// <param name="esuProfile"> Properties for the Machine ESU profile. </param>
        /// <param name="subscriptionStatus"> Indicates the subscription status of the product. </param>
        /// <param name="productType"> Indicates the product type of the license. </param>
        /// <param name="enrollmentOn"> The timestamp in UTC when the user enrolls the feature. </param>
        /// <param name="billingStartOn"> The timestamp in UTC when the billing starts. </param>
        /// <param name="disenrollmentOn"> The timestamp in UTC when the user disenrolled the feature. </param>
        /// <param name="billingEndOn"> The timestamp in UTC when the billing ends. </param>
        /// <param name="error"> The errors that were encountered during the feature enrollment or disenrollment. </param>
        /// <param name="productFeatures"> The list of product features. </param>
        /// <param name="isSoftwareAssuranceCustomer"> Specifies if this machine is licensed as part of a Software Assurance agreement. </param>
        /// <returns> A new <see cref="Models.LicenseProfileMachineInstanceView"/> instance for mocking. </returns>
        public static LicenseProfileMachineInstanceView LicenseProfileMachineInstanceView(HybridComputeLicenseStatus? licenseStatus = null, string licenseChannel = null, LicenseProfileMachineInstanceViewEsuProperties esuProfile = null, LicenseProfileSubscriptionStatus? subscriptionStatus = null, LicenseProfileProductType? productType = null, DateTimeOffset? enrollmentOn = null, DateTimeOffset? billingStartOn = null, DateTimeOffset? disenrollmentOn = null, DateTimeOffset? billingEndOn = null, ResponseError error = null, IEnumerable<HybridComputeProductFeature> productFeatures = null, bool? isSoftwareAssuranceCustomer = null)
        {
            productFeatures ??= new List<HybridComputeProductFeature>();

            return new LicenseProfileMachineInstanceView(
                licenseStatus,
                licenseChannel,
                esuProfile,
                subscriptionStatus,
                productType,
                enrollmentOn,
                billingStartOn,
                disenrollmentOn,
                billingEndOn,
                error,
                productFeatures?.ToList(),
                isSoftwareAssuranceCustomer,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LicenseProfileMachineInstanceViewEsuProperties"/>. </summary>
        /// <param name="assignedLicenseImmutableId"> The guid id of the license. </param>
        /// <param name="esuKeys"> The list of ESU keys. </param>
        /// <param name="serverType"> The type of the Esu servers. </param>
        /// <param name="esuEligibility"> Indicates the eligibility state of Esu. </param>
        /// <param name="esuKeyState"> Indicates whether there is an ESU Key currently active for the machine. </param>
        /// <param name="assignedLicense"> The assigned license resource. </param>
        /// <param name="licenseAssignmentState"> Describes the license assignment state (Assigned or NotAssigned). </param>
        /// <returns> A new <see cref="Models.LicenseProfileMachineInstanceViewEsuProperties"/> instance for mocking. </returns>
        public static LicenseProfileMachineInstanceViewEsuProperties LicenseProfileMachineInstanceViewEsuProperties(Guid? assignedLicenseImmutableId = null, IEnumerable<EsuKey> esuKeys = null, EsuServerType? serverType = null, EsuEligibility? esuEligibility = null, EsuKeyState? esuKeyState = null, HybridComputeLicenseData assignedLicense = null, LicenseAssignmentState? licenseAssignmentState = null)
        {
            esuKeys ??= new List<EsuKey>();

            return new LicenseProfileMachineInstanceViewEsuProperties(
                assignedLicenseImmutableId,
                esuKeys?.ToList(),
                serializedAdditionalRawData: null,
                serverType,
                esuEligibility,
                esuKeyState,
                assignedLicense,
                licenseAssignmentState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LicenseProfileArmEsuPropertiesWithoutAssignedLicense"/>. </summary>
        /// <param name="assignedLicenseImmutableId"> The guid id of the license. </param>
        /// <param name="esuKeys"> The list of ESU keys. </param>
        /// <param name="serverType"> The type of the Esu servers. </param>
        /// <param name="esuEligibility"> Indicates the eligibility state of Esu. </param>
        /// <param name="esuKeyState"> Indicates whether there is an ESU Key currently active for the machine. </param>
        /// <returns> A new <see cref="Models.LicenseProfileArmEsuPropertiesWithoutAssignedLicense"/> instance for mocking. </returns>
        public static LicenseProfileArmEsuPropertiesWithoutAssignedLicense LicenseProfileArmEsuPropertiesWithoutAssignedLicense(Guid? assignedLicenseImmutableId = null, IEnumerable<EsuKey> esuKeys = null, EsuServerType? serverType = null, EsuEligibility? esuEligibility = null, EsuKeyState? esuKeyState = null)
        {
            esuKeys ??= new List<EsuKey>();

            return new LicenseProfileArmEsuPropertiesWithoutAssignedLicense(
                assignedLicenseImmutableId,
                esuKeys?.ToList(),
                serializedAdditionalRawData: null,
                serverType,
                esuEligibility,
                esuKeyState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LicenseProfileStorageModelEsuProperties"/>. </summary>
        /// <param name="assignedLicenseImmutableId"> The guid id of the license. </param>
        /// <param name="esuKeys"> The list of ESU keys. </param>
        /// <returns> A new <see cref="Models.LicenseProfileStorageModelEsuProperties"/> instance for mocking. </returns>
        public static LicenseProfileStorageModelEsuProperties LicenseProfileStorageModelEsuProperties(Guid? assignedLicenseImmutableId = null, IEnumerable<EsuKey> esuKeys = null)
        {
            esuKeys ??= new List<EsuKey>();

            return new LicenseProfileStorageModelEsuProperties(assignedLicenseImmutableId, esuKeys?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EsuKey"/>. </summary>
        /// <param name="sku"> SKU number. </param>
        /// <param name="licenseStatus"> The current status of the license profile key. Represented by the same integer value that is presented on the machine itself when querying the license key status. </param>
        /// <returns> A new <see cref="Models.EsuKey"/> instance for mocking. </returns>
        public static EsuKey EsuKey(string sku = null, int? licenseStatus = null)
        {
            return new EsuKey(sku, licenseStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeProductFeature"/>. </summary>
        /// <param name="name"> Product feature name. </param>
        /// <param name="subscriptionStatus"> Indicates the current status of the product features. </param>
        /// <param name="enrollmentOn"> The timestamp in UTC when the user enrolls the feature. </param>
        /// <param name="billingStartOn"> The timestamp in UTC when the billing starts. </param>
        /// <param name="disenrollmentOn"> The timestamp in UTC when the user disenrolled the feature. </param>
        /// <param name="billingEndOn"> The timestamp in UTC when the billing ends. </param>
        /// <param name="error"> The errors that were encountered during the feature enrollment or disenrollment. </param>
        /// <returns> A new <see cref="Models.HybridComputeProductFeature"/> instance for mocking. </returns>
        public static HybridComputeProductFeature HybridComputeProductFeature(string name = null, LicenseProfileSubscriptionStatus? subscriptionStatus = null, DateTimeOffset? enrollmentOn = null, DateTimeOffset? billingStartOn = null, DateTimeOffset? disenrollmentOn = null, DateTimeOffset? billingEndOn = null, ResponseError error = null)
        {
            return new HybridComputeProductFeature(
                name,
                subscriptionStatus,
                enrollmentOn,
                billingStartOn,
                disenrollmentOn,
                billingEndOn,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeNetworkProfile"/>. </summary>
        /// <param name="networkInterfaces"> The list of network interfaces. </param>
        /// <returns> A new <see cref="Models.HybridComputeNetworkProfile"/> instance for mocking. </returns>
        public static HybridComputeNetworkProfile HybridComputeNetworkProfile(IEnumerable<HybridComputeNetworkInterface> networkInterfaces = null)
        {
            networkInterfaces ??= new List<HybridComputeNetworkInterface>();

            return new HybridComputeNetworkProfile(networkInterfaces?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeNetworkInterface"/>. </summary>
        /// <param name="ipAddresses"> The list of IP addresses in this interface. </param>
        /// <returns> A new <see cref="Models.HybridComputeNetworkInterface"/> instance for mocking. </returns>
        public static HybridComputeNetworkInterface HybridComputeNetworkInterface(IEnumerable<HybridComputeIPAddress> ipAddresses = null)
        {
            ipAddresses ??= new List<HybridComputeIPAddress>();

            return new HybridComputeNetworkInterface(ipAddresses?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeIPAddress"/>. </summary>
        /// <param name="address"> Represents the IP Address. </param>
        /// <param name="ipAddressVersion"> Represents the Ip Address Version. </param>
        /// <param name="subnetAddressPrefix"> The subnet to which this IP address belongs. </param>
        /// <returns> A new <see cref="Models.HybridComputeIPAddress"/> instance for mocking. </returns>
        public static HybridComputeIPAddress HybridComputeIPAddress(string address = null, string ipAddressVersion = null, string subnetAddressPrefix = null)
        {
            return new HybridComputeIPAddress(address, ipAddressVersion, subnetAddressPrefix != null ? new HybridComputeSubnet(subnetAddressPrefix, serializedAdditionalRawData: null) : null, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputeMachineExtensionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Describes Machine Extension Properties. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputeMachineExtensionData"/> instance for mocking. </returns>
        public static HybridComputeMachineExtensionData HybridComputeMachineExtensionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, MachineExtensionProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HybridComputeMachineExtensionData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineExtensionProperties"/>. </summary>
        /// <param name="forceUpdateTag"> How the extension handler should be forced to update even if the extension configuration has not changed. </param>
        /// <param name="publisher"> The name of the extension handler publisher. </param>
        /// <param name="machineExtensionPropertiesType"> Specifies the type of the extension; an example is "CustomScriptExtension". </param>
        /// <param name="typeHandlerVersion"> Specifies the version of the script handler. </param>
        /// <param name="enableAutomaticUpgrade"> Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available. </param>
        /// <param name="autoUpgradeMinorVersion"> Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true. </param>
        /// <param name="settings"> Json formatted public settings for the extension. </param>
        /// <param name="protectedSettings"> The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="instanceView"> The machine extension instance view. </param>
        /// <returns> A new <see cref="Models.MachineExtensionProperties"/> instance for mocking. </returns>
        public static MachineExtensionProperties MachineExtensionProperties(string forceUpdateTag = null, string publisher = null, string machineExtensionPropertiesType = null, string typeHandlerVersion = null, bool? enableAutomaticUpgrade = null, bool? autoUpgradeMinorVersion = null, IDictionary<string, BinaryData> settings = null, IDictionary<string, BinaryData> protectedSettings = null, string provisioningState = null, MachineExtensionInstanceView instanceView = null)
        {
            settings ??= new Dictionary<string, BinaryData>();
            protectedSettings ??= new Dictionary<string, BinaryData>();

            return new MachineExtensionProperties(
                forceUpdateTag,
                publisher,
                machineExtensionPropertiesType,
                typeHandlerVersion,
                enableAutomaticUpgrade,
                autoUpgradeMinorVersion,
                settings,
                protectedSettings,
                provisioningState,
                instanceView,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputeLicenseProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> The provisioning state, which only appears in the response. </param>
        /// <param name="subscriptionStatus"> Indicates the subscription status of the product. </param>
        /// <param name="productType"> Indicates the product type of the license. </param>
        /// <param name="enrollmentOn"> The timestamp in UTC when the user enrolls the feature. </param>
        /// <param name="billingStartOn"> The timestamp in UTC when the billing starts. </param>
        /// <param name="disenrollmentOn"> The timestamp in UTC when the user disenrolled the feature. </param>
        /// <param name="billingEndOn"> The timestamp in UTC when the billing ends. </param>
        /// <param name="error"> The errors that were encountered during the feature enrollment or disenrollment. </param>
        /// <param name="productFeatures"> The list of product features. </param>
        /// <param name="assignedLicenseImmutableId"> The guid id of the license. </param>
        /// <param name="esuKeys"> The list of ESU keys. </param>
        /// <param name="serverType"> The type of the Esu servers. </param>
        /// <param name="esuEligibility"> Indicates the eligibility state of Esu. </param>
        /// <param name="esuKeyState"> Indicates whether there is an ESU Key currently active for the machine. </param>
        /// <param name="assignedLicense"> The resource id of the license. </param>
        /// <param name="softwareAssuranceCustomer"> Specifies if this machine is licensed as part of a Software Assurance agreement. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputeLicenseProfileData"/> instance for mocking. </returns>
        public static HybridComputeLicenseProfileData HybridComputeLicenseProfileData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, HybridComputeProvisioningState? provisioningState = null, LicenseProfileSubscriptionStatus? subscriptionStatus = null, LicenseProfileProductType? productType = null, DateTimeOffset? enrollmentOn = null, DateTimeOffset? billingStartOn = null, DateTimeOffset? disenrollmentOn = null, DateTimeOffset? billingEndOn = null, ResponseError error = null, IEnumerable<HybridComputeProductFeature> productFeatures = null, Guid? assignedLicenseImmutableId = null, IEnumerable<EsuKey> esuKeys = null, EsuServerType? serverType = null, EsuEligibility? esuEligibility = null, EsuKeyState? esuKeyState = null, string assignedLicense = null, bool? softwareAssuranceCustomer = null)
        {
            tags ??= new Dictionary<string, string>();
            productFeatures ??= new List<HybridComputeProductFeature>();
            esuKeys ??= new List<EsuKey>();

            return new HybridComputeLicenseProfileData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                subscriptionStatus,
                productType,
                enrollmentOn,
                billingStartOn,
                disenrollmentOn,
                billingEndOn,
                error,
                productFeatures?.ToList(),
                assignedLicenseImmutableId,
                esuKeys?.ToList(),
                serverType,
                esuEligibility,
                esuKeyState,
                assignedLicense,
                softwareAssuranceCustomer,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineAssessPatchesResult"/>. </summary>
        /// <param name="status"> The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings.". </param>
        /// <param name="assessmentActivityId"> The activity ID of the operation that produced this result. </param>
        /// <param name="isRebootPending"> The overall reboot status of the VM. It will be true when partially installed patches require a reboot to complete installation but the reboot has not yet occurred. </param>
        /// <param name="availablePatchCountByClassification"> Summarization of patches available for installation on the machine by classification. </param>
        /// <param name="startOn"> The UTC timestamp when the operation began. </param>
        /// <param name="lastModifiedOn"> The UTC timestamp when the operation finished. </param>
        /// <param name="startedBy"> Indicates if operation was triggered by user or by platform. </param>
        /// <param name="patchServiceUsed"> Specifies the patch service used for the operation. </param>
        /// <param name="osType"> The operating system type of the machine. </param>
        /// <param name="errorDetails"> The errors that were encountered during execution of the operation. The details array contains the list of them. </param>
        /// <returns> A new <see cref="Models.MachineAssessPatchesResult"/> instance for mocking. </returns>
        public static MachineAssessPatchesResult MachineAssessPatchesResult(MachineOperationStatus? status = null, Guid? assessmentActivityId = null, bool? isRebootPending = null, AvailablePatchCountByClassification availablePatchCountByClassification = null, DateTimeOffset? startOn = null, DateTimeOffset? lastModifiedOn = null, PatchOperationStartedBy? startedBy = null, PatchServiceUsed? patchServiceUsed = null, HybridComputeOSType? osType = null, ResponseError errorDetails = null)
        {
            return new MachineAssessPatchesResult(
                status,
                assessmentActivityId,
                isRebootPending,
                availablePatchCountByClassification,
                startOn,
                lastModifiedOn,
                startedBy,
                patchServiceUsed,
                osType,
                errorDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailablePatchCountByClassification"/>. </summary>
        /// <param name="security"> Number of security patches available for installation. </param>
        /// <param name="critical"> Number of critical patches available for installation. </param>
        /// <param name="definition"> Number of definition patches available for installation. </param>
        /// <param name="updateRollup"> Number of update Rollup patches available for installation. </param>
        /// <param name="featurePack"> Number of feature pack patches available for installation. </param>
        /// <param name="servicePack"> Number of service pack patches available for installation. </param>
        /// <param name="tools"> Number of tools patches available for installation. </param>
        /// <param name="updates"> Number of updates category patches available for installation. </param>
        /// <param name="other"> Number of other patches available for installation. </param>
        /// <returns> A new <see cref="Models.AvailablePatchCountByClassification"/> instance for mocking. </returns>
        public static AvailablePatchCountByClassification AvailablePatchCountByClassification(int? security = null, int? critical = null, int? definition = null, int? updateRollup = null, int? featurePack = null, int? servicePack = null, int? tools = null, int? updates = null, int? other = null)
        {
            return new AvailablePatchCountByClassification(
                security,
                critical,
                definition,
                updateRollup,
                featurePack,
                servicePack,
                tools,
                updates,
                other,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineInstallPatchesContent"/>. </summary>
        /// <param name="maximumDuration"> Specifies the maximum amount of time that the operation will run. It must be an ISO 8601-compliant duration string such as PT4H (4 hours). </param>
        /// <param name="rebootSetting"> Defines when it is acceptable to reboot a VM during a software update operation. </param>
        /// <param name="windowsParameters"> Input for InstallPatches on a Windows VM, as directly received by the API. </param>
        /// <param name="linuxParameters"> Input for InstallPatches on a Linux VM, as directly received by the API. </param>
        /// <returns> A new <see cref="Models.MachineInstallPatchesContent"/> instance for mocking. </returns>
        public static MachineInstallPatchesContent MachineInstallPatchesContent(TimeSpan maximumDuration = default, VmGuestPatchRebootSetting rebootSetting = default, HybridComputeWindowsParameters windowsParameters = null, HybridComputeLinuxParameters linuxParameters = null)
        {
            return new MachineInstallPatchesContent(maximumDuration, rebootSetting, windowsParameters, linuxParameters, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MachineInstallPatchesResult"/>. </summary>
        /// <param name="status"> The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At that point it will become "Failed", "Succeeded", "Unknown" or "CompletedWithWarnings.". </param>
        /// <param name="installationActivityId"> The activity ID of the operation that produced this result. </param>
        /// <param name="rebootStatus"> The reboot state of the VM following completion of the operation. </param>
        /// <param name="maintenanceWindowExceeded"> Whether the operation ran out of time before it completed all its intended actions. </param>
        /// <param name="excludedPatchCount"> The number of patches that were not installed due to the user blocking their installation. </param>
        /// <param name="notSelectedPatchCount"> The number of patches that were detected as available for install, but did not meet the operation's criteria. </param>
        /// <param name="pendingPatchCount"> The number of patches that were identified as meeting the installation criteria, but were not able to be installed. Typically this happens when maintenanceWindowExceeded == true. </param>
        /// <param name="installedPatchCount"> The number of patches successfully installed. </param>
        /// <param name="failedPatchCount"> The number of patches that could not be installed due to some issue. See errors for details. </param>
        /// <param name="startOn"> The UTC timestamp when the operation began. </param>
        /// <param name="lastModifiedOn"> The UTC timestamp when the operation finished. </param>
        /// <param name="startedBy"> Indicates if operation was triggered by user or by platform. </param>
        /// <param name="patchServiceUsed"> Specifies the patch service used for the operation. </param>
        /// <param name="osType"> The operating system type of the machine. </param>
        /// <param name="errorDetails"> The errors that were encountered during execution of the operation. The details array contains the list of them. </param>
        /// <returns> A new <see cref="Models.MachineInstallPatchesResult"/> instance for mocking. </returns>
        public static MachineInstallPatchesResult MachineInstallPatchesResult(MachineOperationStatus? status = null, string installationActivityId = null, VmGuestPatchRebootStatus? rebootStatus = null, bool? maintenanceWindowExceeded = null, int? excludedPatchCount = null, int? notSelectedPatchCount = null, int? pendingPatchCount = null, int? installedPatchCount = null, int? failedPatchCount = null, DateTimeOffset? startOn = null, DateTimeOffset? lastModifiedOn = null, PatchOperationStartedBy? startedBy = null, PatchServiceUsed? patchServiceUsed = null, HybridComputeOSType? osType = null, ResponseError errorDetails = null)
        {
            return new MachineInstallPatchesResult(
                status,
                installationActivityId,
                rebootStatus,
                maintenanceWindowExceeded,
                excludedPatchCount,
                notSelectedPatchCount,
                pendingPatchCount,
                installedPatchCount,
                failedPatchCount,
                startOn,
                lastModifiedOn,
                startedBy,
                patchServiceUsed,
                osType,
                errorDetails,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputeExtensionValueData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="version"> The version of the Extension being received. </param>
        /// <param name="extensionType"> The type of the Extension being received. </param>
        /// <param name="publisher"> The publisher of the Extension being received. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputeExtensionValueData"/> instance for mocking. </returns>
        public static HybridComputeExtensionValueData HybridComputeExtensionValueData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string version = null, string extensionType = null, string publisher = null)
        {
            return new HybridComputeExtensionValueData(
                id,
                name,
                resourceType,
                systemData,
                version,
                extensionType,
                publisher,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputePrivateLinkScopeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Properties that define a Azure Arc PrivateLinkScope resource. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputePrivateLinkScopeData"/> instance for mocking. </returns>
        public static HybridComputePrivateLinkScopeData HybridComputePrivateLinkScopeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, HybridComputePrivateLinkScopeProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new HybridComputePrivateLinkScopeData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputePrivateLinkScopeProperties"/>. </summary>
        /// <param name="publicNetworkAccess"> Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints. </param>
        /// <param name="provisioningState"> Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. </param>
        /// <param name="privateLinkScopeId"> The Guid id of the private link scope. </param>
        /// <param name="privateEndpointConnections"> The collection of associated Private Endpoint Connections. </param>
        /// <returns> A new <see cref="Models.HybridComputePrivateLinkScopeProperties"/> instance for mocking. </returns>
        public static HybridComputePrivateLinkScopeProperties HybridComputePrivateLinkScopeProperties(HybridComputePublicNetworkAccessType? publicNetworkAccess = null, string provisioningState = null, string privateLinkScopeId = null, IEnumerable<PrivateEndpointConnectionDataModel> privateEndpointConnections = null)
        {
            privateEndpointConnections ??= new List<PrivateEndpointConnectionDataModel>();

            return new HybridComputePrivateLinkScopeProperties(publicNetworkAccess, provisioningState, privateLinkScopeId, privateEndpointConnections?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateEndpointConnectionDataModel"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The Private Endpoint Connection properties. </param>
        /// <returns> A new <see cref="Models.PrivateEndpointConnectionDataModel"/> instance for mocking. </returns>
        public static PrivateEndpointConnectionDataModel PrivateEndpointConnectionDataModel(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, HybridComputePrivateEndpointConnectionProperties properties = null)
        {
            return new PrivateEndpointConnectionDataModel(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputePrivateEndpointConnectionProperties"/>. </summary>
        /// <param name="privateEndpointId"> Private endpoint which the connection belongs to. </param>
        /// <param name="connectionState"> Connection state of the private endpoint connection. </param>
        /// <param name="provisioningState"> State of the private endpoint connection. </param>
        /// <param name="groupIds"> List of group IDs. </param>
        /// <returns> A new <see cref="Models.HybridComputePrivateEndpointConnectionProperties"/> instance for mocking. </returns>
        public static HybridComputePrivateEndpointConnectionProperties HybridComputePrivateEndpointConnectionProperties(ResourceIdentifier privateEndpointId = null, HybridComputePrivateLinkServiceConnectionStateProperty connectionState = null, string provisioningState = null, IEnumerable<string> groupIds = null)
        {
            groupIds ??= new List<string>();

            return new HybridComputePrivateEndpointConnectionProperties(privateEndpointId != null ? ResourceManagerModelFactory.WritableSubResource(privateEndpointId) : null, connectionState, provisioningState, groupIds?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputePrivateLinkServiceConnectionStateProperty"/>. </summary>
        /// <param name="status"> The private link service connection status. </param>
        /// <param name="description"> The private link service connection description. </param>
        /// <param name="actionsRequired"> The actions required for private link service connection. </param>
        /// <returns> A new <see cref="Models.HybridComputePrivateLinkServiceConnectionStateProperty"/> instance for mocking. </returns>
        public static HybridComputePrivateLinkServiceConnectionStateProperty HybridComputePrivateLinkServiceConnectionStateProperty(string status = null, string description = null, string actionsRequired = null)
        {
            return new HybridComputePrivateLinkServiceConnectionStateProperty(status, description, actionsRequired, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputePrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Resource properties. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputePrivateLinkResourceData"/> instance for mocking. </returns>
        public static HybridComputePrivateLinkResourceData HybridComputePrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, HybridComputePrivateLinkResourceProperties properties = null)
        {
            return new HybridComputePrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputePrivateLinkResourceProperties"/>. </summary>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> Required DNS zone names of the the private link resource. </param>
        /// <returns> A new <see cref="Models.HybridComputePrivateLinkResourceProperties"/> instance for mocking. </returns>
        public static HybridComputePrivateLinkResourceProperties HybridComputePrivateLinkResourceProperties(string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new HybridComputePrivateLinkResourceProperties(groupId, requiredMembers?.ToList(), requiredZoneNames?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.HybridComputePrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Resource properties. </param>
        /// <returns> A new <see cref="HybridCompute.HybridComputePrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static HybridComputePrivateEndpointConnectionData HybridComputePrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, HybridComputePrivateEndpointConnectionProperties properties = null)
        {
            return new HybridComputePrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrivateLinkScopeValidationDetails"/>. </summary>
        /// <param name="id"> Azure resource Id. </param>
        /// <param name="publicNetworkAccess"> Indicates whether machines associated with the private link scope can also use public Azure Arc service endpoints. </param>
        /// <param name="connectionDetails"> List of Private Endpoint Connection details. </param>
        /// <returns> A new <see cref="Models.PrivateLinkScopeValidationDetails"/> instance for mocking. </returns>
        public static PrivateLinkScopeValidationDetails PrivateLinkScopeValidationDetails(ResourceIdentifier id = null, HybridComputePublicNetworkAccessType? publicNetworkAccess = null, IEnumerable<HybridComputeConnectionDetail> connectionDetails = null)
        {
            connectionDetails ??= new List<HybridComputeConnectionDetail>();

            return new PrivateLinkScopeValidationDetails(id, publicNetworkAccess, connectionDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeConnectionDetail"/>. </summary>
        /// <param name="id"> Azure resource Id. </param>
        /// <param name="privateIPAddress"> The private endpoint connection private ip address. </param>
        /// <param name="linkIdentifier"> The private endpoint connection link identifier. </param>
        /// <param name="groupId"> The private endpoint connection group id. </param>
        /// <param name="memberName"> The private endpoint connection member name. </param>
        /// <returns> A new <see cref="Models.HybridComputeConnectionDetail"/> instance for mocking. </returns>
        public static HybridComputeConnectionDetail HybridComputeConnectionDetail(ResourceIdentifier id = null, string privateIPAddress = null, string linkIdentifier = null, string groupId = null, string memberName = null)
        {
            return new HybridComputeConnectionDetail(
                id,
                privateIPAddress,
                linkIdentifier,
                groupId,
                memberName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="HybridCompute.NetworkSecurityPerimeterConfigurationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Current state of this NetworkSecurityPerimeter: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. </param>
        /// <param name="provisioningIssues"> Provisioning issues. </param>
        /// <param name="networkSecurityPerimeter"> The Network Security Perimeter associated with this configuration. </param>
        /// <param name="resourceAssociation"> The Resource Association. </param>
        /// <param name="profile"> Network Security Perimeter profile. </param>
        /// <returns> A new <see cref="HybridCompute.NetworkSecurityPerimeterConfigurationData"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeterConfigurationData NetworkSecurityPerimeterConfigurationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string provisioningState = null, IEnumerable<HybridComputeProvisioningIssue> provisioningIssues = null, NetworkSecurityPerimeter networkSecurityPerimeter = null, HybridComputeResourceAssociation resourceAssociation = null, NetworkSecurityPerimeterProfile profile = null)
        {
            provisioningIssues ??= new List<HybridComputeProvisioningIssue>();

            return new NetworkSecurityPerimeterConfigurationData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                provisioningIssues?.ToList(),
                networkSecurityPerimeter,
                resourceAssociation,
                profile,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeProvisioningIssue"/>. </summary>
        /// <param name="name"> Name of the provisioning issue. </param>
        /// <param name="issueType"> Issue type. </param>
        /// <param name="severity"> Severity of the provisioning issue. </param>
        /// <param name="description"> Description of the provisioning issue. </param>
        /// <param name="suggestedResourceIds"> ARM Ids of the resources that can be associated to the same perimeter to remediate the issue. </param>
        /// <param name="suggestedAccessRules"> Access rules that can be added to the perimeter to remediate the issue. </param>
        /// <returns> A new <see cref="Models.HybridComputeProvisioningIssue"/> instance for mocking. </returns>
        public static HybridComputeProvisioningIssue HybridComputeProvisioningIssue(string name = null, HybridComputeProvisioningIssueType? issueType = null, HybridComputeProvisioningIssueSeverity? severity = null, string description = null, IEnumerable<string> suggestedResourceIds = null, IEnumerable<HybridComputeAccessRule> suggestedAccessRules = null)
        {
            suggestedResourceIds ??= new List<string>();
            suggestedAccessRules ??= new List<HybridComputeAccessRule>();

            return new HybridComputeProvisioningIssue(
                name,
                issueType,
                severity,
                description,
                suggestedResourceIds?.ToList(),
                suggestedAccessRules?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeAccessRule"/>. </summary>
        /// <param name="name"> Name of the access rule. </param>
        /// <param name="direction"> Direction of the access rule. </param>
        /// <param name="addressPrefixes"> Address prefixes that are allowed access. </param>
        /// <returns> A new <see cref="Models.HybridComputeAccessRule"/> instance for mocking. </returns>
        public static HybridComputeAccessRule HybridComputeAccessRule(string name = null, HybridComputeAccessRuleDirection? direction = null, IEnumerable<string> addressPrefixes = null)
        {
            addressPrefixes ??= new List<string>();

            return new HybridComputeAccessRule(name, direction, addressPrefixes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkSecurityPerimeter"/>. </summary>
        /// <param name="id"> Azure resource Id. </param>
        /// <param name="perimeterGuid"> Guid of the Network Security Perimeter. </param>
        /// <param name="location"> Regional location of the perimeter. </param>
        /// <returns> A new <see cref="Models.NetworkSecurityPerimeter"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeter NetworkSecurityPerimeter(string id = null, string perimeterGuid = null, AzureLocation? location = null)
        {
            return new NetworkSecurityPerimeter(id, perimeterGuid, location, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.HybridComputeResourceAssociation"/>. </summary>
        /// <param name="name"> Name of the Resource Association. </param>
        /// <param name="accessMode"> The access mode. </param>
        /// <returns> A new <see cref="Models.HybridComputeResourceAssociation"/> instance for mocking. </returns>
        public static HybridComputeResourceAssociation HybridComputeResourceAssociation(string name = null, HybridComputeAccessMode? accessMode = null)
        {
            return new HybridComputeResourceAssociation(name, accessMode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkSecurityPerimeterProfile"/>. </summary>
        /// <param name="name"> Name of the resource. </param>
        /// <param name="accessRulesVersion"> Access rules version number. </param>
        /// <param name="accessRules"> Collection of access rules for the profile. </param>
        /// <param name="diagnosticSettingsVersion"> Diagnostic settings version number. </param>
        /// <param name="enabledLogCategories"> Collection of enabled log categories for the profile. </param>
        /// <returns> A new <see cref="Models.NetworkSecurityPerimeterProfile"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeterProfile NetworkSecurityPerimeterProfile(string name = null, int? accessRulesVersion = null, IEnumerable<HybridComputeAccessRule> accessRules = null, int? diagnosticSettingsVersion = null, IEnumerable<string> enabledLogCategories = null)
        {
            accessRules ??= new List<HybridComputeAccessRule>();
            enabledLogCategories ??= new List<string>();

            return new NetworkSecurityPerimeterProfile(
                name,
                accessRulesVersion,
                accessRules?.ToList(),
                diagnosticSettingsVersion,
                enabledLogCategories?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NetworkSecurityPerimeterConfigurationReconcileResult"/>. </summary>
        /// <param name="location"> The URL of the resource used to check the status of the asynchronous operation. </param>
        /// <returns> A new <see cref="Models.NetworkSecurityPerimeterConfigurationReconcileResult"/> instance for mocking. </returns>
        public static NetworkSecurityPerimeterConfigurationReconcileResult NetworkSecurityPerimeterConfigurationReconcileResult(AzureLocation? location = null)
        {
            return new NetworkSecurityPerimeterConfigurationReconcileResult(location, serializedAdditionalRawData: null);
        }
    }
}
