// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.HybridContainerService.Models;

namespace Azure.ResourceManager.HybridContainerService
{
    internal partial class ProvisionedClusterInstancesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of ProvisionedClusterInstancesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public ProvisionedClusterInstancesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2024-01-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetRequestUri(string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets the provisioned cluster instance. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response<ProvisionedClusterData>> GetAsync(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateGetRequest(connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ProvisionedClusterData.DeserializeProvisionedClusterData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((ProvisionedClusterData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the provisioned cluster instance. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response<ProvisionedClusterData> Get(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateGetRequest(connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ProvisionedClusterData.DeserializeProvisionedClusterData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((ProvisionedClusterData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string connectedClusterResourceUri, ProvisionedClusterData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string connectedClusterResourceUri, ProvisionedClusterData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates or updates the provisioned cluster instance. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="data"> Provisioned Cluster resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> or <paramref name="data"/> is null. </exception>
        public async Task<Response> CreateOrUpdateAsync(string connectedClusterResourceUri, ProvisionedClusterData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(connectedClusterResourceUri, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates the provisioned cluster instance. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="data"> Provisioned Cluster resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> or <paramref name="data"/> is null. </exception>
        public Response CreateOrUpdate(string connectedClusterResourceUri, ProvisionedClusterData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(connectedClusterResourceUri, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes the provisioned cluster instance. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response> DeleteAsync(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateDeleteRequest(connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes the provisioned cluster instance. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response Delete(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateDeleteRequest(connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListRequestUri(string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the ProvisionedClusterInstance resource associated with the ConnectedCluster. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response<ProvisionedClusterListResult>> ListAsync(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListRequest(connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ProvisionedClusterListResult.DeserializeProvisionedClusterListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the ProvisionedClusterInstance resource associated with the ConnectedCluster. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response<ProvisionedClusterListResult> List(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListRequest(connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ProvisionedClusterListResult.DeserializeProvisionedClusterListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetUpgradeProfileRequestUri(string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/upgradeProfiles/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetUpgradeProfileRequest(string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/upgradeProfiles/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets the upgrade profile of a provisioned cluster. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response<ProvisionedClusterUpgradeProfileData>> GetUpgradeProfileAsync(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateGetUpgradeProfileRequest(connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterUpgradeProfileData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ProvisionedClusterUpgradeProfileData.DeserializeProvisionedClusterUpgradeProfileData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((ProvisionedClusterUpgradeProfileData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the upgrade profile of a provisioned cluster. </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response<ProvisionedClusterUpgradeProfileData> GetUpgradeProfile(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateGetUpgradeProfileRequest(connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterUpgradeProfileData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ProvisionedClusterUpgradeProfileData.DeserializeProvisionedClusterUpgradeProfileData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((ProvisionedClusterUpgradeProfileData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListUserKubeconfigRequestUri(string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/listUserKubeconfig", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListUserKubeconfigRequest(string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/listUserKubeconfig", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the user credentials of the provisioned cluster (can only be used within private network). </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response> ListUserKubeconfigAsync(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListUserKubeconfigRequest(connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the user credentials of the provisioned cluster (can only be used within private network). </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response ListUserKubeconfig(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListUserKubeconfigRequest(connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListAdminKubeconfigRequestUri(string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/listAdminKubeconfig", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListAdminKubeconfigRequest(string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(connectedClusterResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/provisionedClusterInstances/default/listAdminKubeconfig", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the admin credentials of the provisioned cluster (can only be used within private network). </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response> ListAdminKubeconfigAsync(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListAdminKubeconfigRequest(connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the admin credentials of the provisioned cluster (can only be used within private network). </summary>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response ListAdminKubeconfig(string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListAdminKubeconfigRequest(connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string connectedClusterResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string connectedClusterResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the ProvisionedClusterInstance resource associated with the ConnectedCluster. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public async Task<Response<ProvisionedClusterListResult>> ListNextPageAsync(string nextLink, string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListNextPageRequest(nextLink, connectedClusterResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ProvisionedClusterListResult.DeserializeProvisionedClusterListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the ProvisionedClusterInstance resource associated with the ConnectedCluster. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="connectedClusterResourceUri"> The fully qualified Azure Resource Manager identifier of the connected cluster resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="connectedClusterResourceUri"/> is null. </exception>
        public Response<ProvisionedClusterListResult> ListNextPage(string nextLink, string connectedClusterResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(connectedClusterResourceUri, nameof(connectedClusterResourceUri));

            using var message = CreateListNextPageRequest(nextLink, connectedClusterResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ProvisionedClusterListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ProvisionedClusterListResult.DeserializeProvisionedClusterListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
