// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.HybridContainerService
{
    internal partial class HybridContainerServiceRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of HybridContainerServiceRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public HybridContainerServiceRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2024-01-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetKubernetesVersionsRequestUri(string customLocationResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/kubernetesVersions/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetKubernetesVersionsRequest(string customLocationResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/kubernetesVersions/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the supported kubernetes versions for the specified custom location. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public async Task<Response<KubernetesVersionProfileData>> GetKubernetesVersionsAsync(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateGetKubernetesVersionsRequest(customLocationResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        KubernetesVersionProfileData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = KubernetesVersionProfileData.DeserializeKubernetesVersionProfileData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((KubernetesVersionProfileData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the supported kubernetes versions for the specified custom location. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public Response<KubernetesVersionProfileData> GetKubernetesVersions(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateGetKubernetesVersionsRequest(customLocationResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        KubernetesVersionProfileData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = KubernetesVersionProfileData.DeserializeKubernetesVersionProfileData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((KubernetesVersionProfileData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreatePutKubernetesVersionsRequestUri(string customLocationResourceUri, KubernetesVersionProfileData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/kubernetesVersions/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreatePutKubernetesVersionsRequest(string customLocationResourceUri, KubernetesVersionProfileData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/kubernetesVersions/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Puts the default kubernetes version resource type (one time operation, before listing the kubernetes versions). </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="data"> Kubernetes Versions resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> or <paramref name="data"/> is null. </exception>
        public async Task<Response> PutKubernetesVersionsAsync(string customLocationResourceUri, KubernetesVersionProfileData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreatePutKubernetesVersionsRequest(customLocationResourceUri, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Puts the default kubernetes version resource type (one time operation, before listing the kubernetes versions). </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="data"> Kubernetes Versions resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> or <paramref name="data"/> is null. </exception>
        public Response PutKubernetesVersions(string customLocationResourceUri, KubernetesVersionProfileData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreatePutKubernetesVersionsRequest(customLocationResourceUri, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteKubernetesVersionsRequestUri(string customLocationResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/kubernetesVersions/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteKubernetesVersionsRequest(string customLocationResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/kubernetesVersions/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Delete the default kubernetes versions resource type. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public async Task<Response> DeleteKubernetesVersionsAsync(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateDeleteKubernetesVersionsRequest(customLocationResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete the default kubernetes versions resource type. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public Response DeleteKubernetesVersions(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateDeleteKubernetesVersionsRequest(customLocationResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetVmSkusRequestUri(string customLocationResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/skus/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetVmSkusRequest(string customLocationResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/skus/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists the supported VM skus for the specified custom location. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public async Task<Response<HybridContainerServiceVmSkuData>> GetVmSkusAsync(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateGetVmSkusRequest(customLocationResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        HybridContainerServiceVmSkuData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = HybridContainerServiceVmSkuData.DeserializeHybridContainerServiceVmSkuData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((HybridContainerServiceVmSkuData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists the supported VM skus for the specified custom location. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public Response<HybridContainerServiceVmSkuData> GetVmSkus(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateGetVmSkusRequest(customLocationResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        HybridContainerServiceVmSkuData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = HybridContainerServiceVmSkuData.DeserializeHybridContainerServiceVmSkuData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((HybridContainerServiceVmSkuData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreatePutVmSkusRequestUri(string customLocationResourceUri, HybridContainerServiceVmSkuData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/skus/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreatePutVmSkusRequest(string customLocationResourceUri, HybridContainerServiceVmSkuData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/skus/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Puts the default VM skus resource type (one time operation, before listing the VM skus). </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="data"> VM SKUs resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> or <paramref name="data"/> is null. </exception>
        public async Task<Response> PutVmSkusAsync(string customLocationResourceUri, HybridContainerServiceVmSkuData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreatePutVmSkusRequest(customLocationResourceUri, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Puts the default VM skus resource type (one time operation, before listing the VM skus). </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="data"> VM SKUs resource definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> or <paramref name="data"/> is null. </exception>
        public Response PutVmSkus(string customLocationResourceUri, HybridContainerServiceVmSkuData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreatePutVmSkusRequest(customLocationResourceUri, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteVmSkusRequestUri(string customLocationResourceUri)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/skus/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteVmSkusRequest(string customLocationResourceUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(customLocationResourceUri, false);
            uri.AppendPath("/providers/Microsoft.HybridContainerService/skus/default", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Deletes the default VM skus resource type. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public async Task<Response> DeleteVmSkusAsync(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateDeleteVmSkusRequest(customLocationResourceUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Deletes the default VM skus resource type. </summary>
        /// <param name="customLocationResourceUri"> The fully qualified Azure Resource Manager identifier of the custom location resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="customLocationResourceUri"/> is null. </exception>
        public Response DeleteVmSkus(string customLocationResourceUri, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(customLocationResourceUri, nameof(customLocationResourceUri));

            using var message = CreateDeleteVmSkusRequest(customLocationResourceUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
