// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> NFS CSI Driver settings for the storage profile. </summary>
    internal partial class StorageProfileNfsCSIDriver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageProfileNfsCSIDriver"/>. </summary>
        public StorageProfileNfsCSIDriver()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageProfileNfsCSIDriver"/>. </summary>
        /// <param name="isNfsCsiDriverEnabled"> Indicates whether to enable NFS CSI Driver. The default value is true. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageProfileNfsCSIDriver(bool? isNfsCsiDriverEnabled, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsNfsCsiDriverEnabled = isNfsCsiDriverEnabled;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates whether to enable NFS CSI Driver. The default value is true. </summary>
        public bool? IsNfsCsiDriverEnabled { get; set; }
    }
}
