// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The storage configuration profile for the provisioned cluster. </summary>
    public partial class StorageProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageProfile"/>. </summary>
        public StorageProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="StorageProfile"/>. </summary>
        /// <param name="smbCsiDriver"> SMB CSI Driver settings for the storage profile. </param>
        /// <param name="nfsCsiDriver"> NFS CSI Driver settings for the storage profile. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageProfile(StorageProfileSmbCSIDriver smbCsiDriver, StorageProfileNfsCSIDriver nfsCsiDriver, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SmbCsiDriver = smbCsiDriver;
            NfsCsiDriver = nfsCsiDriver;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SMB CSI Driver settings for the storage profile. </summary>
        internal StorageProfileSmbCSIDriver SmbCsiDriver { get; set; }
        /// <summary> Indicates whether to enable SMB CSI Driver. The default value is true. </summary>
        public bool? IsSmbCsiDriverEnabled
        {
            get => SmbCsiDriver is null ? default : SmbCsiDriver.IsSmbCsiDriverEnabled;
            set
            {
                if (SmbCsiDriver is null)
                    SmbCsiDriver = new StorageProfileSmbCSIDriver();
                SmbCsiDriver.IsSmbCsiDriverEnabled = value;
            }
        }

        /// <summary> NFS CSI Driver settings for the storage profile. </summary>
        internal StorageProfileNfsCSIDriver NfsCsiDriver { get; set; }
        /// <summary> Indicates whether to enable NFS CSI Driver. The default value is true. </summary>
        public bool? IsNfsCsiDriverEnabled
        {
            get => NfsCsiDriver is null ? default : NfsCsiDriver.IsNfsCsiDriverEnabled;
            set
            {
                if (NfsCsiDriver is null)
                    NfsCsiDriver = new StorageProfileNfsCSIDriver();
                NfsCsiDriver.IsNfsCsiDriverEnabled = value;
            }
        }
    }
}
