// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> Properties of the provisioned cluster. </summary>
    public partial class ProvisionedClusterProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterProperties"/>. </summary>
        public ProvisionedClusterProperties()
        {
            AgentPoolProfiles = new ChangeTrackingList<HybridContainerServiceNamedAgentPoolProfile>();
        }

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterProperties"/>. </summary>
        /// <param name="linuxProfile"> The profile for Linux VMs in the provisioned cluster. </param>
        /// <param name="controlPlane"> The profile for control plane of the provisioned cluster. </param>
        /// <param name="kubernetesVersion"> The version of Kubernetes in use by the provisioned cluster. </param>
        /// <param name="networkProfile"> The network configuration profile for the provisioned cluster. </param>
        /// <param name="storageProfile"> The storage configuration profile for the provisioned cluster. </param>
        /// <param name="clusterVmAccessProfile"> The SSH restricted access profile for the VMs in the provisioned cluster. </param>
        /// <param name="agentPoolProfiles"> The agent pool properties for the provisioned cluster. </param>
        /// <param name="cloudProviderProfile"> The profile for the underlying cloud infrastructure provider for the provisioned cluster. </param>
        /// <param name="provisioningState"> The status of the latest long running operation for the provisioned cluster. </param>
        /// <param name="status"> The observed status of the provisioned cluster. </param>
        /// <param name="licenseProfile"> The license profile of the provisioned cluster. </param>
        /// <param name="autoScalerProfile"> Parameters to be applied to the cluster-autoscaler when auto scaling is enabled for the provisioned cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProvisionedClusterProperties(LinuxProfileProperties linuxProfile, ProvisionedClusterControlPlaneProfile controlPlane, string kubernetesVersion, ProvisionedClusterNetworkProfile networkProfile, StorageProfile storageProfile, ClusterVmAccessProfile clusterVmAccessProfile, IList<HybridContainerServiceNamedAgentPoolProfile> agentPoolProfiles, ProvisionedClusterCloudProviderProfile cloudProviderProfile, HybridContainerServiceResourceProvisioningState? provisioningState, ProvisionedClusterStatus status, ProvisionedClusterLicenseProfile licenseProfile, ProvisionedClusterPropertiesAutoScalerProfile autoScalerProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LinuxProfile = linuxProfile;
            ControlPlane = controlPlane;
            KubernetesVersion = kubernetesVersion;
            NetworkProfile = networkProfile;
            StorageProfile = storageProfile;
            ClusterVmAccessProfile = clusterVmAccessProfile;
            AgentPoolProfiles = agentPoolProfiles;
            CloudProviderProfile = cloudProviderProfile;
            ProvisioningState = provisioningState;
            Status = status;
            LicenseProfile = licenseProfile;
            AutoScalerProfile = autoScalerProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The profile for Linux VMs in the provisioned cluster. </summary>
        internal LinuxProfileProperties LinuxProfile { get; set; }
        /// <summary> The list of SSH public keys used to authenticate with VMs. A maximum of 1 key may be specified. </summary>
        public IList<LinuxSshPublicKey> SshPublicKeys
        {
            get
            {
                if (LinuxProfile is null)
                    LinuxProfile = new LinuxProfileProperties();
                return LinuxProfile.SshPublicKeys;
            }
        }

        /// <summary> The profile for control plane of the provisioned cluster. </summary>
        public ProvisionedClusterControlPlaneProfile ControlPlane { get; set; }
        /// <summary> The version of Kubernetes in use by the provisioned cluster. </summary>
        public string KubernetesVersion { get; set; }
        /// <summary> The network configuration profile for the provisioned cluster. </summary>
        public ProvisionedClusterNetworkProfile NetworkProfile { get; set; }
        /// <summary> The storage configuration profile for the provisioned cluster. </summary>
        public StorageProfile StorageProfile { get; set; }
        /// <summary> The SSH restricted access profile for the VMs in the provisioned cluster. </summary>
        internal ClusterVmAccessProfile ClusterVmAccessProfile { get; set; }
        /// <summary> IP Address or CIDR for SSH access to VMs in the provisioned cluster. </summary>
        public string ClusterVmAccessAuthorizedIPRanges
        {
            get => ClusterVmAccessProfile is null ? default : ClusterVmAccessProfile.AuthorizedIPRanges;
            set
            {
                if (ClusterVmAccessProfile is null)
                    ClusterVmAccessProfile = new ClusterVmAccessProfile();
                ClusterVmAccessProfile.AuthorizedIPRanges = value;
            }
        }

        /// <summary> The agent pool properties for the provisioned cluster. </summary>
        public IList<HybridContainerServiceNamedAgentPoolProfile> AgentPoolProfiles { get; }
        /// <summary> The profile for the underlying cloud infrastructure provider for the provisioned cluster. </summary>
        internal ProvisionedClusterCloudProviderProfile CloudProviderProfile { get; set; }
        /// <summary> List of ARM resource Ids (maximum 1) for the infrastructure network object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}. </summary>
        public IList<ResourceIdentifier> InfraNetworkVnetSubnetIds
        {
            get
            {
                if (CloudProviderProfile is null)
                    CloudProviderProfile = new ProvisionedClusterCloudProviderProfile();
                return CloudProviderProfile.InfraNetworkVnetSubnetIds;
            }
        }

        /// <summary> The status of the latest long running operation for the provisioned cluster. </summary>
        public HybridContainerServiceResourceProvisioningState? ProvisioningState { get; }
        /// <summary> The observed status of the provisioned cluster. </summary>
        public ProvisionedClusterStatus Status { get; }
        /// <summary> The license profile of the provisioned cluster. </summary>
        internal ProvisionedClusterLicenseProfile LicenseProfile { get; set; }
        /// <summary> Indicates whether Azure Hybrid Benefit is opted in. Default value is false. </summary>
        public ProvisionedClusterAzureHybridBenefit? LicenseAzureHybridBenefit
        {
            get => LicenseProfile is null ? default : LicenseProfile.AzureHybridBenefit;
            set
            {
                if (LicenseProfile is null)
                    LicenseProfile = new ProvisionedClusterLicenseProfile();
                LicenseProfile.AzureHybridBenefit = value;
            }
        }

        /// <summary> Parameters to be applied to the cluster-autoscaler when auto scaling is enabled for the provisioned cluster. </summary>
        public ProvisionedClusterPropertiesAutoScalerProfile AutoScalerProfile { get; set; }
    }
}
