// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The list of available kubernetes versions for upgrade. </summary>
    public partial class ProvisionedClusterPoolUpgradeProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterPoolUpgradeProfile"/>. </summary>
        public ProvisionedClusterPoolUpgradeProfile()
        {
            Upgrades = new ChangeTrackingList<ProvisionedClusterPoolUpgradeProfileProperties>();
        }

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterPoolUpgradeProfile"/>. </summary>
        /// <param name="kubernetesVersion"> The Kubernetes version (major.minor.patch). </param>
        /// <param name="osType"> The particular KubernetesVersion Image OS Type (Linux, Windows). </param>
        /// <param name="upgrades"> List of available kubernetes versions for upgrade. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProvisionedClusterPoolUpgradeProfile(string kubernetesVersion, HybridContainerServiceOSType? osType, IList<ProvisionedClusterPoolUpgradeProfileProperties> upgrades, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KubernetesVersion = kubernetesVersion;
            OSType = osType;
            Upgrades = upgrades;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Kubernetes version (major.minor.patch). </summary>
        public string KubernetesVersion { get; }
        /// <summary> The particular KubernetesVersion Image OS Type (Linux, Windows). </summary>
        public HybridContainerServiceOSType? OSType { get; }
        /// <summary> List of available kubernetes versions for upgrade. </summary>
        public IList<ProvisionedClusterPoolUpgradeProfileProperties> Upgrades { get; }
    }
}
