// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The network configuration profile for the provisioned cluster. </summary>
    public partial class ProvisionedClusterNetworkProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterNetworkProfile"/>. </summary>
        public ProvisionedClusterNetworkProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterNetworkProfile"/>. </summary>
        /// <param name="loadBalancerProfile"> Profile of the HA Proxy load balancer. </param>
        /// <param name="networkPolicy"> Network policy used for building Kubernetes network. Possible values include: 'calico'. </param>
        /// <param name="podCidr"> A CIDR notation IP Address range from which to assign pod IPs. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProvisionedClusterNetworkProfile(ProvisionedClusterLoadBalancerProfile loadBalancerProfile, ProvisionedClusterNetworkPolicy? networkPolicy, string podCidr, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LoadBalancerProfile = loadBalancerProfile;
            NetworkPolicy = networkPolicy;
            PodCidr = podCidr;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Profile of the HA Proxy load balancer. </summary>
        internal ProvisionedClusterLoadBalancerProfile LoadBalancerProfile { get; set; }
        /// <summary> Number of HA Proxy load balancer VMs. The default value is 0. </summary>
        public int? LoadBalancerCount
        {
            get => LoadBalancerProfile is null ? default : LoadBalancerProfile.Count;
            set
            {
                if (LoadBalancerProfile is null)
                    LoadBalancerProfile = new ProvisionedClusterLoadBalancerProfile();
                LoadBalancerProfile.Count = value;
            }
        }

        /// <summary> Network policy used for building Kubernetes network. Possible values include: 'calico'. </summary>
        public ProvisionedClusterNetworkPolicy? NetworkPolicy { get; set; }
        /// <summary> A CIDR notation IP Address range from which to assign pod IPs. </summary>
        public string PodCidr { get; set; }
    }
}
