// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> Network policy used for building Kubernetes network. Possible values include: 'calico'. </summary>
    public readonly partial struct ProvisionedClusterNetworkPolicy : IEquatable<ProvisionedClusterNetworkPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterNetworkPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProvisionedClusterNetworkPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CalicoValue = "calico";

        /// <summary> calico. </summary>
        public static ProvisionedClusterNetworkPolicy Calico { get; } = new ProvisionedClusterNetworkPolicy(CalicoValue);
        /// <summary> Determines if two <see cref="ProvisionedClusterNetworkPolicy"/> values are the same. </summary>
        public static bool operator ==(ProvisionedClusterNetworkPolicy left, ProvisionedClusterNetworkPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProvisionedClusterNetworkPolicy"/> values are not the same. </summary>
        public static bool operator !=(ProvisionedClusterNetworkPolicy left, ProvisionedClusterNetworkPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProvisionedClusterNetworkPolicy"/>. </summary>
        public static implicit operator ProvisionedClusterNetworkPolicy(string value) => new ProvisionedClusterNetworkPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProvisionedClusterNetworkPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProvisionedClusterNetworkPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
