// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The profile for the underlying cloud infrastructure provider for the provisioned cluster. </summary>
    internal partial class ProvisionedClusterCloudProviderProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterCloudProviderProfile"/>. </summary>
        public ProvisionedClusterCloudProviderProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterCloudProviderProfile"/>. </summary>
        /// <param name="infraNetworkProfile"> The profile for the infrastructure networks used by the provisioned cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProvisionedClusterCloudProviderProfile(ProvisionedClusterInfraNetworkProfile infraNetworkProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InfraNetworkProfile = infraNetworkProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The profile for the infrastructure networks used by the provisioned cluster. </summary>
        internal ProvisionedClusterInfraNetworkProfile InfraNetworkProfile { get; set; }
        /// <summary> List of ARM resource Ids (maximum 1) for the infrastructure network object e.g. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/logicalNetworks/{logicalNetworkName}. </summary>
        public IList<ResourceIdentifier> InfraNetworkVnetSubnetIds
        {
            get
            {
                if (InfraNetworkProfile is null)
                    InfraNetworkProfile = new ProvisionedClusterInfraNetworkProfile();
                return InfraNetworkProfile.VnetSubnetIds;
            }
        }
    }
}
