// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> Indicates whether Azure Hybrid Benefit is opted in. Default value is false. </summary>
    public readonly partial struct ProvisionedClusterAzureHybridBenefit : IEquatable<ProvisionedClusterAzureHybridBenefit>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterAzureHybridBenefit"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProvisionedClusterAzureHybridBenefit(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrueValue = "True";
        private const string FalseValue = "False";
        private const string NotApplicableValue = "NotApplicable";

        /// <summary> True. </summary>
        public static ProvisionedClusterAzureHybridBenefit True { get; } = new ProvisionedClusterAzureHybridBenefit(TrueValue);
        /// <summary> False. </summary>
        public static ProvisionedClusterAzureHybridBenefit False { get; } = new ProvisionedClusterAzureHybridBenefit(FalseValue);
        /// <summary> NotApplicable. </summary>
        public static ProvisionedClusterAzureHybridBenefit NotApplicable { get; } = new ProvisionedClusterAzureHybridBenefit(NotApplicableValue);
        /// <summary> Determines if two <see cref="ProvisionedClusterAzureHybridBenefit"/> values are the same. </summary>
        public static bool operator ==(ProvisionedClusterAzureHybridBenefit left, ProvisionedClusterAzureHybridBenefit right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProvisionedClusterAzureHybridBenefit"/> values are not the same. </summary>
        public static bool operator !=(ProvisionedClusterAzureHybridBenefit left, ProvisionedClusterAzureHybridBenefit right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProvisionedClusterAzureHybridBenefit"/>. </summary>
        public static implicit operator ProvisionedClusterAzureHybridBenefit(string value) => new ProvisionedClusterAzureHybridBenefit(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProvisionedClusterAzureHybridBenefit other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProvisionedClusterAzureHybridBenefit other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
