// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> Observed phase of the addon or component on the provisioned cluster. Possible values include: 'pending', 'provisioning', 'provisioning {HelmChartInstalled}', 'provisioning {MSICertificateDownloaded}', 'provisioned', 'deleting', 'failed', 'upgrading'. </summary>
    public readonly partial struct ProvisionedClusterAddonPhase : IEquatable<ProvisionedClusterAddonPhase>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProvisionedClusterAddonPhase"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProvisionedClusterAddonPhase(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "pending";
        private const string ProvisioningValue = "provisioning";
        private const string ProvisioningHelmChartInstalledValue = "provisioning {HelmChartInstalled}";
        private const string ProvisioningMSICertificateDownloadedValue = "provisioning {MSICertificateDownloaded}";
        private const string ProvisionedValue = "provisioned";
        private const string DeletingValue = "deleting";
        private const string FailedValue = "failed";
        private const string UpgradingValue = "upgrading";

        /// <summary> pending. </summary>
        public static ProvisionedClusterAddonPhase Pending { get; } = new ProvisionedClusterAddonPhase(PendingValue);
        /// <summary> provisioning. </summary>
        public static ProvisionedClusterAddonPhase Provisioning { get; } = new ProvisionedClusterAddonPhase(ProvisioningValue);
        /// <summary> provisioning {HelmChartInstalled}. </summary>
        public static ProvisionedClusterAddonPhase ProvisioningHelmChartInstalled { get; } = new ProvisionedClusterAddonPhase(ProvisioningHelmChartInstalledValue);
        /// <summary> provisioning {MSICertificateDownloaded}. </summary>
        public static ProvisionedClusterAddonPhase ProvisioningMSICertificateDownloaded { get; } = new ProvisionedClusterAddonPhase(ProvisioningMSICertificateDownloadedValue);
        /// <summary> provisioned. </summary>
        public static ProvisionedClusterAddonPhase Provisioned { get; } = new ProvisionedClusterAddonPhase(ProvisionedValue);
        /// <summary> deleting. </summary>
        public static ProvisionedClusterAddonPhase Deleting { get; } = new ProvisionedClusterAddonPhase(DeletingValue);
        /// <summary> failed. </summary>
        public static ProvisionedClusterAddonPhase Failed { get; } = new ProvisionedClusterAddonPhase(FailedValue);
        /// <summary> upgrading. </summary>
        public static ProvisionedClusterAddonPhase Upgrading { get; } = new ProvisionedClusterAddonPhase(UpgradingValue);
        /// <summary> Determines if two <see cref="ProvisionedClusterAddonPhase"/> values are the same. </summary>
        public static bool operator ==(ProvisionedClusterAddonPhase left, ProvisionedClusterAddonPhase right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProvisionedClusterAddonPhase"/> values are not the same. </summary>
        public static bool operator !=(ProvisionedClusterAddonPhase left, ProvisionedClusterAddonPhase right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProvisionedClusterAddonPhase"/>. </summary>
        public static implicit operator ProvisionedClusterAddonPhase(string value) => new ProvisionedClusterAddonPhase(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProvisionedClusterAddonPhase other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProvisionedClusterAddonPhase other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
