// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> SSH profile for control plane and nodepool VMs of the provisioned cluster. </summary>
    internal partial class LinuxProfileProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LinuxProfileProperties"/>. </summary>
        public LinuxProfileProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LinuxProfileProperties"/>. </summary>
        /// <param name="ssh"> SSH configuration for VMs of the provisioned cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LinuxProfileProperties(LinuxSshConfiguration ssh, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Ssh = ssh;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SSH configuration for VMs of the provisioned cluster. </summary>
        internal LinuxSshConfiguration Ssh { get; set; }
        /// <summary> The list of SSH public keys used to authenticate with VMs. A maximum of 1 key may be specified. </summary>
        public IList<LinuxSshPublicKey> SshPublicKeys
        {
            get
            {
                if (Ssh is null)
                    Ssh = new LinuxSshConfiguration();
                return Ssh.PublicKeys;
            }
        }
    }
}
