// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The KubernetesVirtualIPItem. </summary>
    public partial class KubernetesVirtualIPItem
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KubernetesVirtualIPItem"/>. </summary>
        public KubernetesVirtualIPItem()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KubernetesVirtualIPItem"/>. </summary>
        /// <param name="endIP"> Ending IP address for the IP Pool. </param>
        /// <param name="startIP"> Starting IP address for the IP Pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KubernetesVirtualIPItem(string endIP, string startIP, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EndIP = endIP;
            StartIP = startIP;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Ending IP address for the IP Pool. </summary>
        public string EndIP { get; set; }
        /// <summary> Starting IP address for the IP Pool. </summary>
        public string StartIP { get; set; }
    }
}
