// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The HybridContainerServiceProvisioningState. </summary>
    public readonly partial struct HybridContainerServiceProvisioningState : IEquatable<HybridContainerServiceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridContainerServiceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridContainerServiceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string PendingValue = "Pending";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string UpdatingValue = "Updating";
        private const string AcceptedValue = "Accepted";

        /// <summary> Succeeded. </summary>
        public static HybridContainerServiceProvisioningState Succeeded { get; } = new HybridContainerServiceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static HybridContainerServiceProvisioningState Failed { get; } = new HybridContainerServiceProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static HybridContainerServiceProvisioningState Canceled { get; } = new HybridContainerServiceProvisioningState(CanceledValue);
        /// <summary> Pending. </summary>
        public static HybridContainerServiceProvisioningState Pending { get; } = new HybridContainerServiceProvisioningState(PendingValue);
        /// <summary> Creating. </summary>
        public static HybridContainerServiceProvisioningState Creating { get; } = new HybridContainerServiceProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static HybridContainerServiceProvisioningState Deleting { get; } = new HybridContainerServiceProvisioningState(DeletingValue);
        /// <summary> Updating. </summary>
        public static HybridContainerServiceProvisioningState Updating { get; } = new HybridContainerServiceProvisioningState(UpdatingValue);
        /// <summary> Accepted. </summary>
        public static HybridContainerServiceProvisioningState Accepted { get; } = new HybridContainerServiceProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="HybridContainerServiceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HybridContainerServiceProvisioningState left, HybridContainerServiceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridContainerServiceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HybridContainerServiceProvisioningState left, HybridContainerServiceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridContainerServiceProvisioningState"/>. </summary>
        public static implicit operator HybridContainerServiceProvisioningState(string value) => new HybridContainerServiceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridContainerServiceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridContainerServiceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
