// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> The extended location type. Allowed value: 'CustomLocation'. </summary>
    public readonly partial struct HybridContainerServiceExtendedLocationType : IEquatable<HybridContainerServiceExtendedLocationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HybridContainerServiceExtendedLocationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HybridContainerServiceExtendedLocationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomLocationValue = "CustomLocation";

        /// <summary> CustomLocation. </summary>
        public static HybridContainerServiceExtendedLocationType CustomLocation { get; } = new HybridContainerServiceExtendedLocationType(CustomLocationValue);
        /// <summary> Determines if two <see cref="HybridContainerServiceExtendedLocationType"/> values are the same. </summary>
        public static bool operator ==(HybridContainerServiceExtendedLocationType left, HybridContainerServiceExtendedLocationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HybridContainerServiceExtendedLocationType"/> values are not the same. </summary>
        public static bool operator !=(HybridContainerServiceExtendedLocationType left, HybridContainerServiceExtendedLocationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HybridContainerServiceExtendedLocationType"/>. </summary>
        public static implicit operator HybridContainerServiceExtendedLocationType(string value) => new HybridContainerServiceExtendedLocationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HybridContainerServiceExtendedLocationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HybridContainerServiceExtendedLocationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
