// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.HybridContainerService.Models
{
    /// <summary> Extended location pointing to the underlying infrastructure. </summary>
    public partial class HybridContainerServiceExtendedLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HybridContainerServiceExtendedLocation"/>. </summary>
        public HybridContainerServiceExtendedLocation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HybridContainerServiceExtendedLocation"/>. </summary>
        /// <param name="extendedLocationType"> The extended location type. Allowed value: 'CustomLocation'. </param>
        /// <param name="name"> ARM Id of the extended location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HybridContainerServiceExtendedLocation(HybridContainerServiceExtendedLocationType? extendedLocationType, string name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExtendedLocationType = extendedLocationType;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The extended location type. Allowed value: 'CustomLocation'. </summary>
        public HybridContainerServiceExtendedLocationType? ExtendedLocationType { get; set; }
        /// <summary> ARM Id of the extended location. </summary>
        public string Name { get; set; }
    }
}
