// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridContainerService
{
    internal class ProvisionedClusterOperationSource : IOperationSource<ProvisionedClusterResource>
    {
        private readonly ArmClient _client;

        internal ProvisionedClusterOperationSource(ArmClient client)
        {
            _client = client;
        }

        ProvisionedClusterResource IOperationSource<ProvisionedClusterResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ProvisionedClusterData.DeserializeProvisionedClusterData(document.RootElement);
            return new ProvisionedClusterResource(_client, data);
        }

        async ValueTask<ProvisionedClusterResource> IOperationSource<ProvisionedClusterResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ProvisionedClusterData.DeserializeProvisionedClusterData(document.RootElement);
            return new ProvisionedClusterResource(_client, data);
        }
    }
}
