// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridContainerService
{
    internal class KubernetesVersionProfileOperationSource : IOperationSource<KubernetesVersionProfileResource>
    {
        private readonly ArmClient _client;

        internal KubernetesVersionProfileOperationSource(ArmClient client)
        {
            _client = client;
        }

        KubernetesVersionProfileResource IOperationSource<KubernetesVersionProfileResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = KubernetesVersionProfileData.DeserializeKubernetesVersionProfileData(document.RootElement);
            return new KubernetesVersionProfileResource(_client, data);
        }

        async ValueTask<KubernetesVersionProfileResource> IOperationSource<KubernetesVersionProfileResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = KubernetesVersionProfileData.DeserializeKubernetesVersionProfileData(document.RootElement);
            return new KubernetesVersionProfileResource(_client, data);
        }
    }
}
