// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridContainerService
{
    internal class HybridContainerServiceVmSkuOperationSource : IOperationSource<HybridContainerServiceVmSkuResource>
    {
        private readonly ArmClient _client;

        internal HybridContainerServiceVmSkuOperationSource(ArmClient client)
        {
            _client = client;
        }

        HybridContainerServiceVmSkuResource IOperationSource<HybridContainerServiceVmSkuResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HybridContainerServiceVmSkuData.DeserializeHybridContainerServiceVmSkuData(document.RootElement);
            return new HybridContainerServiceVmSkuResource(_client, data);
        }

        async ValueTask<HybridContainerServiceVmSkuResource> IOperationSource<HybridContainerServiceVmSkuResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HybridContainerServiceVmSkuData.DeserializeHybridContainerServiceVmSkuData(document.RootElement);
            return new HybridContainerServiceVmSkuResource(_client, data);
        }
    }
}
