// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HybridContainerService
{
    internal class HybridContainerServiceVirtualNetworkOperationSource : IOperationSource<HybridContainerServiceVirtualNetworkResource>
    {
        private readonly ArmClient _client;

        internal HybridContainerServiceVirtualNetworkOperationSource(ArmClient client)
        {
            _client = client;
        }

        HybridContainerServiceVirtualNetworkResource IOperationSource<HybridContainerServiceVirtualNetworkResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HybridContainerServiceVirtualNetworkData.DeserializeHybridContainerServiceVirtualNetworkData(document.RootElement);
            return new HybridContainerServiceVirtualNetworkResource(_client, data);
        }

        async ValueTask<HybridContainerServiceVirtualNetworkResource> IOperationSource<HybridContainerServiceVirtualNetworkResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HybridContainerServiceVirtualNetworkData.DeserializeHybridContainerServiceVirtualNetworkData(document.RootElement);
            return new HybridContainerServiceVirtualNetworkResource(_client, data);
        }
    }
}
