// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.HybridContainerService.Models;

namespace Azure.ResourceManager.HybridContainerService
{
    internal class HybridContainerServiceCredentialListResultOperationSource : IOperationSource<HybridContainerServiceCredentialListResult>
    {
        HybridContainerServiceCredentialListResult IOperationSource<HybridContainerServiceCredentialListResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return HybridContainerServiceCredentialListResult.DeserializeHybridContainerServiceCredentialListResult(document.RootElement);
        }

        async ValueTask<HybridContainerServiceCredentialListResult> IOperationSource<HybridContainerServiceCredentialListResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return HybridContainerServiceCredentialListResult.DeserializeHybridContainerServiceCredentialListResult(document.RootElement);
        }
    }
}
