// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Known values codes that can be used to indicate the type of the Specialty. </summary>
    public readonly partial struct SpecialtyType : IEquatable<SpecialtyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SpecialtyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SpecialtyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PathologyValue = "pathology";
        private const string RadiologyValue = "radiology";

        /// <summary> pathology. </summary>
        public static SpecialtyType Pathology { get; } = new SpecialtyType(PathologyValue);
        /// <summary> radiology. </summary>
        public static SpecialtyType Radiology { get; } = new SpecialtyType(RadiologyValue);
        /// <summary> Determines if two <see cref="SpecialtyType"/> values are the same. </summary>
        public static bool operator ==(SpecialtyType left, SpecialtyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SpecialtyType"/> values are not the same. </summary>
        public static bool operator !=(SpecialtyType left, SpecialtyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SpecialtyType"/>. </summary>
        public static implicit operator SpecialtyType(string value) => new SpecialtyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SpecialtyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SpecialtyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
