// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> https://www.hl7.org/fhir/R4/codesystem-research-study-status.html. </summary>
    public readonly partial struct ResearchStudyStatusCodeType : IEquatable<ResearchStudyStatusCodeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResearchStudyStatusCodeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResearchStudyStatusCodeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "active";
        private const string AdministrativelyCompletedValue = "administratively-completed";
        private const string ApprovedValue = "approved";
        private const string ClosedToAccrualValue = "closed-to-accrual";
        private const string ClosedToAccrualAndInterventionValue = "closed-to-accrual-and-intervention";
        private const string CompletedValue = "completed";
        private const string DisapprovedValue = "disapproved";
        private const string InReviewValue = "in-review";
        private const string TemporarilyClosedToAccrualValue = "temporarily-closed-to-accrual";
        private const string TemporarilyClosedToAccrualAndInterventionValue = "temporarily-closed-to-accrual-and-intervention";
        private const string WithdrawnValue = "withdrawn";

        /// <summary> The study is open for accrual. </summary>
        public static ResearchStudyStatusCodeType Active { get; } = new ResearchStudyStatusCodeType(ActiveValue);
        /// <summary> Study is completed prematurely and will not resume; patients are no longer examined nor treated. </summary>
        public static ResearchStudyStatusCodeType AdministrativelyCompleted { get; } = new ResearchStudyStatusCodeType(AdministrativelyCompletedValue);
        /// <summary> Protocol is approved by the review board. </summary>
        public static ResearchStudyStatusCodeType Approved { get; } = new ResearchStudyStatusCodeType(ApprovedValue);
        /// <summary> Study is closed for accrual; patients can be examined and treated. </summary>
        public static ResearchStudyStatusCodeType ClosedToAccrual { get; } = new ResearchStudyStatusCodeType(ClosedToAccrualValue);
        /// <summary> The study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study subjects have completed treatment or intervention but are still being followed according to the primary objective of the study. </summary>
        public static ResearchStudyStatusCodeType ClosedToAccrualAndIntervention { get; } = new ResearchStudyStatusCodeType(ClosedToAccrualAndInterventionValue);
        /// <summary> Study is closed to accrual and intervention, i.e. the study is closed to enrollment, all study subjects have completed treatment or intervention but are still being followed according to the primary objective of the study. </summary>
        public static ResearchStudyStatusCodeType Completed { get; } = new ResearchStudyStatusCodeType(CompletedValue);
        /// <summary> Protocol was disapproved by the review board. </summary>
        public static ResearchStudyStatusCodeType Disapproved { get; } = new ResearchStudyStatusCodeType(DisapprovedValue);
        /// <summary> Protocol is submitted to the review board for approval. </summary>
        public static ResearchStudyStatusCodeType InReview { get; } = new ResearchStudyStatusCodeType(InReviewValue);
        /// <summary> The study is temporarily closed to accrual; a pause in accrual while study is reviewed, but is expected to resume. </summary>
        public static ResearchStudyStatusCodeType TemporarilyClosedToAccrual { get; } = new ResearchStudyStatusCodeType(TemporarilyClosedToAccrualValue);
        /// <summary> Study is temporarily closed for accrual; can be potentially resumed in the future. </summary>
        public static ResearchStudyStatusCodeType TemporarilyClosedToAccrualAndIntervention { get; } = new ResearchStudyStatusCodeType(TemporarilyClosedToAccrualAndInterventionValue);
        /// <summary> Protocol was withdrawn by the lead organization. </summary>
        public static ResearchStudyStatusCodeType Withdrawn { get; } = new ResearchStudyStatusCodeType(WithdrawnValue);
        /// <summary> Determines if two <see cref="ResearchStudyStatusCodeType"/> values are the same. </summary>
        public static bool operator ==(ResearchStudyStatusCodeType left, ResearchStudyStatusCodeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResearchStudyStatusCodeType"/> values are not the same. </summary>
        public static bool operator !=(ResearchStudyStatusCodeType left, ResearchStudyStatusCodeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResearchStudyStatusCodeType"/>. </summary>
        public static implicit operator ResearchStudyStatusCodeType(string value) => new ResearchStudyStatusCodeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResearchStudyStatusCodeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResearchStudyStatusCodeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
