// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Recommendation finding status. </summary>
    public readonly partial struct RecommendationFindingStatusType : IEquatable<RecommendationFindingStatusType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecommendationFindingStatusType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecommendationFindingStatusType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PresentValue = "present";
        private const string DifferentialValue = "differential";
        private const string RuleOutValue = "ruleOut";
        private const string ConditionalValue = "conditional";

        /// <summary> Present finding status. </summary>
        public static RecommendationFindingStatusType Present { get; } = new RecommendationFindingStatusType(PresentValue);
        /// <summary> Differential finding status. </summary>
        public static RecommendationFindingStatusType Differential { get; } = new RecommendationFindingStatusType(DifferentialValue);
        /// <summary> Rule out finding status. </summary>
        public static RecommendationFindingStatusType RuleOut { get; } = new RecommendationFindingStatusType(RuleOutValue);
        /// <summary> Conditional finding status. </summary>
        public static RecommendationFindingStatusType Conditional { get; } = new RecommendationFindingStatusType(ConditionalValue);
        /// <summary> Determines if two <see cref="RecommendationFindingStatusType"/> values are the same. </summary>
        public static bool operator ==(RecommendationFindingStatusType left, RecommendationFindingStatusType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecommendationFindingStatusType"/> values are not the same. </summary>
        public static bool operator !=(RecommendationFindingStatusType left, RecommendationFindingStatusType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RecommendationFindingStatusType"/>. </summary>
        public static implicit operator RecommendationFindingStatusType(string value) => new RecommendationFindingStatusType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecommendationFindingStatusType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecommendationFindingStatusType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
