// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Finding reference for recommendation. </summary>
    public partial class RecommendationFinding
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecommendationFinding"/>. </summary>
        /// <param name="recommendationFindingStatus"> Recommendation finding status. </param>
        internal RecommendationFinding(RecommendationFindingStatusType recommendationFindingStatus)
        {
            RecommendationFindingStatus = recommendationFindingStatus;
            Extension = new ChangeTrackingList<FhirR4Extension>();
        }

        /// <summary> Initializes a new instance of <see cref="RecommendationFinding"/>. </summary>
        /// <param name="finding"> Finding linked to a recommendation. </param>
        /// <param name="criticalFinding"> Critical result linked to a recommendation. </param>
        /// <param name="recommendationFindingStatus"> Recommendation finding status. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecommendationFinding(FhirR4Observation finding, CriticalResult criticalFinding, RecommendationFindingStatusType recommendationFindingStatus, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Finding = finding;
            CriticalFinding = criticalFinding;
            RecommendationFindingStatus = recommendationFindingStatus;
            Extension = extension;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RecommendationFinding"/> for deserialization. </summary>
        internal RecommendationFinding()
        {
        }

        /// <summary> Finding linked to a recommendation. </summary>
        public FhirR4Observation Finding { get; }
        /// <summary> Critical result linked to a recommendation. </summary>
        public CriticalResult CriticalFinding { get; }
        /// <summary> Recommendation finding status. </summary>
        public RecommendationFindingStatusType RecommendationFindingStatus { get; }
        /// <summary> Additional Content defined by implementations. </summary>
        public IReadOnlyList<FhirR4Extension> Extension { get; }
    }
}
