// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Configuration affecting the Radiology Insights model's inference. </summary>
    public partial class RadiologyInsightsModelConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RadiologyInsightsModelConfiguration"/>. </summary>
        public RadiologyInsightsModelConfiguration()
        {
            InferenceTypes = new ChangeTrackingList<RadiologyInsightsInferenceType>();
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsightsModelConfiguration"/>. </summary>
        /// <param name="verbose"> An indication whether the model should produce verbose output. </param>
        /// <param name="includeEvidence"> An indication whether the model's output should include evidence for the inferences. </param>
        /// <param name="inferenceTypes"> This is a list of inference types to be inferred for the current request. It could be used if only part of the Radiology Insights inferences are required. If this list is omitted or empty, the model will return all the inference types. </param>
        /// <param name="inferenceOptions"> Options regarding follow up recommendation inferences and finding inferences. </param>
        /// <param name="locale"> Local for the model to use. If not specified, the model will use the default locale. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RadiologyInsightsModelConfiguration(bool? verbose, bool? includeEvidence, IList<RadiologyInsightsInferenceType> inferenceTypes, RadiologyInsightsInferenceOptions inferenceOptions, string locale, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Verbose = verbose;
            IncludeEvidence = includeEvidence;
            InferenceTypes = inferenceTypes;
            InferenceOptions = inferenceOptions;
            Locale = locale;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An indication whether the model should produce verbose output. </summary>
        public bool? Verbose { get; set; }
        /// <summary> An indication whether the model's output should include evidence for the inferences. </summary>
        public bool? IncludeEvidence { get; set; }
        /// <summary> This is a list of inference types to be inferred for the current request. It could be used if only part of the Radiology Insights inferences are required. If this list is omitted or empty, the model will return all the inference types. </summary>
        public IList<RadiologyInsightsInferenceType> InferenceTypes { get; }
        /// <summary> Options regarding follow up recommendation inferences and finding inferences. </summary>
        public RadiologyInsightsInferenceOptions InferenceOptions { get; set; }
        /// <summary> Local for the model to use. If not specified, the model will use the default locale. </summary>
        public string Locale { get; set; }
    }
}
