// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.RadiologyInsights
{
    public partial class RadiologyInsightsModelConfiguration : IUtf8JsonSerializable, IJsonModel<RadiologyInsightsModelConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RadiologyInsightsModelConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RadiologyInsightsModelConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RadiologyInsightsModelConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RadiologyInsightsModelConfiguration)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Verbose))
            {
                writer.WritePropertyName("verbose"u8);
                writer.WriteBooleanValue(Verbose.Value);
            }
            if (Optional.IsDefined(IncludeEvidence))
            {
                writer.WritePropertyName("includeEvidence"u8);
                writer.WriteBooleanValue(IncludeEvidence.Value);
            }
            if (Optional.IsCollectionDefined(InferenceTypes))
            {
                writer.WritePropertyName("inferenceTypes"u8);
                writer.WriteStartArray();
                foreach (var item in InferenceTypes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(InferenceOptions))
            {
                writer.WritePropertyName("inferenceOptions"u8);
                writer.WriteObjectValue(InferenceOptions, options);
            }
            if (Optional.IsDefined(Locale))
            {
                writer.WritePropertyName("locale"u8);
                writer.WriteStringValue(Locale);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RadiologyInsightsModelConfiguration IJsonModel<RadiologyInsightsModelConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RadiologyInsightsModelConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RadiologyInsightsModelConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRadiologyInsightsModelConfiguration(document.RootElement, options);
        }

        internal static RadiologyInsightsModelConfiguration DeserializeRadiologyInsightsModelConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? verbose = default;
            bool? includeEvidence = default;
            IList<RadiologyInsightsInferenceType> inferenceTypes = default;
            RadiologyInsightsInferenceOptions inferenceOptions = default;
            string locale = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("verbose"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    verbose = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("includeEvidence"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    includeEvidence = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("inferenceTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RadiologyInsightsInferenceType> array = new List<RadiologyInsightsInferenceType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new RadiologyInsightsInferenceType(item.GetString()));
                    }
                    inferenceTypes = array;
                    continue;
                }
                if (property.NameEquals("inferenceOptions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    inferenceOptions = RadiologyInsightsInferenceOptions.DeserializeRadiologyInsightsInferenceOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("locale"u8))
                {
                    locale = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RadiologyInsightsModelConfiguration(
                verbose,
                includeEvidence,
                inferenceTypes ?? new ChangeTrackingList<RadiologyInsightsInferenceType>(),
                inferenceOptions,
                locale,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RadiologyInsightsModelConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RadiologyInsightsModelConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RadiologyInsightsModelConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        RadiologyInsightsModelConfiguration IPersistableModel<RadiologyInsightsModelConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RadiologyInsightsModelConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRadiologyInsightsModelConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RadiologyInsightsModelConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RadiologyInsightsModelConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RadiologyInsightsModelConfiguration FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRadiologyInsightsModelConfiguration(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
