// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Response for the Radiology Insights request. </summary>
    public partial class RadiologyInsightsJob
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RadiologyInsightsJob"/>. </summary>
        public RadiologyInsightsJob()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsightsJob"/>. </summary>
        /// <param name="jobData"> The request data for the operation. </param>
        /// <param name="result"> The result of the operation. </param>
        /// <param name="id"> The unique ID of the job. </param>
        /// <param name="status"> The status of the job. </param>
        /// <param name="createdAt"> The date and time when the processing job was created. </param>
        /// <param name="expiresAt"> The date and time when the processing job is set to expire. </param>
        /// <param name="updatedAt"> The date and time when the processing job was last updated. </param>
        /// <param name="error"> Error object that describes the error when status is "Failed". </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RadiologyInsightsJob(RadiologyInsightsData jobData, RadiologyInsightsInferenceResult result, string id, JobStatus status, DateTimeOffset? createdAt, DateTimeOffset? expiresAt, DateTimeOffset? updatedAt, ResponseError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            JobData = jobData;
            Result = result;
            Id = id;
            Status = status;
            CreatedAt = createdAt;
            ExpiresAt = expiresAt;
            UpdatedAt = updatedAt;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The request data for the operation. </summary>
        public RadiologyInsightsData JobData { get; set; }
        /// <summary> The result of the operation. </summary>
        public RadiologyInsightsInferenceResult Result { get; }
        /// <summary> The unique ID of the job. </summary>
        public string Id { get; }
        /// <summary> The status of the job. </summary>
        public JobStatus Status { get; }
        /// <summary> The date and time when the processing job was created. </summary>
        public DateTimeOffset? CreatedAt { get; }
        /// <summary> The date and time when the processing job is set to expire. </summary>
        public DateTimeOffset? ExpiresAt { get; }
        /// <summary> The date and time when the processing job was last updated. </summary>
        public DateTimeOffset? UpdatedAt { get; }
        /// <summary> Error object that describes the error when status is "Failed". </summary>
        public ResponseError Error { get; }
    }
}
