// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> The patient's sex. </summary>
    public readonly partial struct PatientSex : IEquatable<PatientSex>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PatientSex"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PatientSex(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FemaleValue = "female";
        private const string MaleValue = "male";
        private const string UnspecifiedValue = "unspecified";

        /// <summary> female. </summary>
        public static PatientSex Female { get; } = new PatientSex(FemaleValue);
        /// <summary> male. </summary>
        public static PatientSex Male { get; } = new PatientSex(MaleValue);
        /// <summary> unspecified. </summary>
        public static PatientSex Unspecified { get; } = new PatientSex(UnspecifiedValue);
        /// <summary> Determines if two <see cref="PatientSex"/> values are the same. </summary>
        public static bool operator ==(PatientSex left, PatientSex right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PatientSex"/> values are not the same. </summary>
        public static bool operator !=(PatientSex left, PatientSex right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PatientSex"/>. </summary>
        public static implicit operator PatientSex(string value) => new PatientSex(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PatientSex other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PatientSex other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
