// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> visit/encounter information. </summary>
    public partial class PatientEncounter
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PatientEncounter"/>. </summary>
        /// <param name="id"> The id of the visit. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="id"/> is null. </exception>
        public PatientEncounter(string id)
        {
            Argument.AssertNotNull(id, nameof(id));

            Id = id;
        }

        /// <summary> Initializes a new instance of <see cref="PatientEncounter"/>. </summary>
        /// <param name="id"> The id of the visit. </param>
        /// <param name="period">
        /// Time period of the visit.
        /// In case of admission, use timePeriod.start to indicate the admission time and timePeriod.end to indicate the discharge time.
        /// </param>
        /// <param name="class"> The class of the encounter. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PatientEncounter(string id, TimePeriod period, EncounterClass? @class, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Period = period;
            Class = @class;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="PatientEncounter"/> for deserialization. </summary>
        internal PatientEncounter()
        {
        }

        /// <summary> The id of the visit. </summary>
        public string Id { get; set; }
        /// <summary>
        /// Time period of the visit.
        /// In case of admission, use timePeriod.start to indicate the admission time and timePeriod.end to indicate the discharge time.
        /// </summary>
        public TimePeriod Period { get; set; }
        /// <summary> The class of the encounter. </summary>
        public EncounterClass? Class { get; set; }
    }
}
