// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Observation Status
    /// Based on [FHIR ObservationStatus](https://www.hl7.org/fhir/R4/valueset-observation-status.html)
    /// </summary>
    public readonly partial struct ObservationStatusCodeType : IEquatable<ObservationStatusCodeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ObservationStatusCodeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ObservationStatusCodeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteredValue = "registered";
        private const string PreliminaryValue = "preliminary";
        private const string FinalValue = "final";
        private const string AmendedValue = "amended";
        private const string CorrectedValue = "corrected";
        private const string CancelledValue = "cancelled";
        private const string EnteredInErrorValue = "entered-in-error";
        private const string UnknownValue = "unknown";

        /// <summary> The existence of the observation is registered, but there is no result yet available. </summary>
        public static ObservationStatusCodeType Registered { get; } = new ObservationStatusCodeType(RegisteredValue);
        /// <summary> This is an initial or interim observation: data may be incomplete or unverified. </summary>
        public static ObservationStatusCodeType Preliminary { get; } = new ObservationStatusCodeType(PreliminaryValue);
        /// <summary> The observation is complete and verified by an authorized person. </summary>
        public static ObservationStatusCodeType Final { get; } = new ObservationStatusCodeType(FinalValue);
        /// <summary> Subsequent to being Final, the observation has been modified subsequent.  This includes updates/new information and corrections. </summary>
        public static ObservationStatusCodeType Amended { get; } = new ObservationStatusCodeType(AmendedValue);
        /// <summary> Subsequent to being Final, the observation has been modified to correct an error in the test result. </summary>
        public static ObservationStatusCodeType Corrected { get; } = new ObservationStatusCodeType(CorrectedValue);
        /// <summary> The observation is unavailable because the measurement was not started or not completed (also sometimes called "aborted"). </summary>
        public static ObservationStatusCodeType Cancelled { get; } = new ObservationStatusCodeType(CancelledValue);
        /// <summary> The observation has been withdrawn following previous final release. </summary>
        public static ObservationStatusCodeType EnteredInError { get; } = new ObservationStatusCodeType(EnteredInErrorValue);
        /// <summary> The observation status is unknown.  Note that "unknown" is a value of last resort and every attempt should be made to provide a meaningful value other than "unknown". </summary>
        public static ObservationStatusCodeType Unknown { get; } = new ObservationStatusCodeType(UnknownValue);
        /// <summary> Determines if two <see cref="ObservationStatusCodeType"/> values are the same. </summary>
        public static bool operator ==(ObservationStatusCodeType left, ObservationStatusCodeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ObservationStatusCodeType"/> values are not the same. </summary>
        public static bool operator !=(ObservationStatusCodeType left, ObservationStatusCodeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ObservationStatusCodeType"/>. </summary>
        public static implicit operator ObservationStatusCodeType(string value) => new ObservationStatusCodeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ObservationStatusCodeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ObservationStatusCodeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
