// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Medical Professional Type. </summary>
    public readonly partial struct MedicalProfessionalType : IEquatable<MedicalProfessionalType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MedicalProfessionalType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MedicalProfessionalType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "unknown";
        private const string DoctorValue = "doctor";
        private const string NurseValue = "nurse";
        private const string MidwifeValue = "midwife";
        private const string PhysicianAssistantValue = "physicianAssistant";

        /// <summary> Unknown medical professional type. </summary>
        public static MedicalProfessionalType Unknown { get; } = new MedicalProfessionalType(UnknownValue);
        /// <summary> Doctor medical professional type. </summary>
        public static MedicalProfessionalType Doctor { get; } = new MedicalProfessionalType(DoctorValue);
        /// <summary> Nurse medical professional type. </summary>
        public static MedicalProfessionalType Nurse { get; } = new MedicalProfessionalType(NurseValue);
        /// <summary> Technician medical professional type. </summary>
        public static MedicalProfessionalType Midwife { get; } = new MedicalProfessionalType(MidwifeValue);
        /// <summary> Technician medical professional type. </summary>
        public static MedicalProfessionalType PhysicianAssistant { get; } = new MedicalProfessionalType(PhysicianAssistantValue);
        /// <summary> Determines if two <see cref="MedicalProfessionalType"/> values are the same. </summary>
        public static bool operator ==(MedicalProfessionalType left, MedicalProfessionalType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MedicalProfessionalType"/> values are not the same. </summary>
        public static bool operator !=(MedicalProfessionalType left, MedicalProfessionalType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MedicalProfessionalType"/>. </summary>
        public static implicit operator MedicalProfessionalType(string value) => new MedicalProfessionalType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MedicalProfessionalType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MedicalProfessionalType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
