// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Laterality discrepancy type. </summary>
    public readonly partial struct LateralityDiscrepancyType : IEquatable<LateralityDiscrepancyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LateralityDiscrepancyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LateralityDiscrepancyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OrderLateralityMismatchValue = "orderLateralityMismatch";
        private const string TextLateralityContradictionValue = "textLateralityContradiction";
        private const string TextLateralityMissingValue = "textLateralityMissing";

        /// <summary> Mismatch between order and text. </summary>
        public static LateralityDiscrepancyType OrderLateralityMismatch { get; } = new LateralityDiscrepancyType(OrderLateralityMismatchValue);
        /// <summary> Contradiction in text. </summary>
        public static LateralityDiscrepancyType TextLateralityContradiction { get; } = new LateralityDiscrepancyType(TextLateralityContradictionValue);
        /// <summary> Missing laterality in text. </summary>
        public static LateralityDiscrepancyType TextLateralityMissing { get; } = new LateralityDiscrepancyType(TextLateralityMissingValue);
        /// <summary> Determines if two <see cref="LateralityDiscrepancyType"/> values are the same. </summary>
        public static bool operator ==(LateralityDiscrepancyType left, LateralityDiscrepancyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LateralityDiscrepancyType"/> values are not the same. </summary>
        public static bool operator !=(LateralityDiscrepancyType left, LateralityDiscrepancyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LateralityDiscrepancyType"/>. </summary>
        public static implicit operator LateralityDiscrepancyType(string value) => new LateralityDiscrepancyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LateralityDiscrepancyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LateralityDiscrepancyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
