// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Imaging procedures. </summary>
    public partial class ImagingProcedureRecommendation : ProcedureRecommendation
    {
        /// <summary> Initializes a new instance of <see cref="ImagingProcedureRecommendation"/>. </summary>
        /// <param name="imagingProcedures"> Imaging procedures. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imagingProcedures"/> is null. </exception>
        internal ImagingProcedureRecommendation(IEnumerable<ImagingProcedure> imagingProcedures)
        {
            Argument.AssertNotNull(imagingProcedures, nameof(imagingProcedures));

            Kind = "imagingProcedureRecommendation";
            ProcedureCodes = new ChangeTrackingList<FhirR4CodeableConcept>();
            ImagingProcedures = imagingProcedures.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ImagingProcedureRecommendation"/>. </summary>
        /// <param name="kind"> Discriminator property for ProcedureRecommendation. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="procedureCodes"> LOINC codes for the procedure. </param>
        /// <param name="imagingProcedures"> Imaging procedures. </param>
        internal ImagingProcedureRecommendation(string kind, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<FhirR4CodeableConcept> procedureCodes, IReadOnlyList<ImagingProcedure> imagingProcedures) : base(kind, extension, serializedAdditionalRawData)
        {
            ProcedureCodes = procedureCodes;
            ImagingProcedures = imagingProcedures;
        }

        /// <summary> Initializes a new instance of <see cref="ImagingProcedureRecommendation"/> for deserialization. </summary>
        internal ImagingProcedureRecommendation()
        {
        }

        /// <summary> LOINC codes for the procedure. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> ProcedureCodes { get; }
        /// <summary> Imaging procedures. </summary>
        public IReadOnlyList<ImagingProcedure> ImagingProcedures { get; }
    }
}
