// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Imaging procedure. </summary>
    public partial class ImagingProcedure
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ImagingProcedure"/>. </summary>
        /// <param name="modality"> Modality : SNOMED CT code. </param>
        /// <param name="anatomy"> Anatomy : SNOMED CT code. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="modality"/> or <paramref name="anatomy"/> is null. </exception>
        internal ImagingProcedure(FhirR4CodeableConcept modality, FhirR4CodeableConcept anatomy)
        {
            Argument.AssertNotNull(modality, nameof(modality));
            Argument.AssertNotNull(anatomy, nameof(anatomy));

            Modality = modality;
            Anatomy = anatomy;
        }

        /// <summary> Initializes a new instance of <see cref="ImagingProcedure"/>. </summary>
        /// <param name="modality"> Modality : SNOMED CT code. </param>
        /// <param name="anatomy"> Anatomy : SNOMED CT code. </param>
        /// <param name="laterality"> Laterality : SNOMED CT code. </param>
        /// <param name="contrast"> Contrast : see RadiologyCodeWithTypes (below). </param>
        /// <param name="view"> View : see RadiologyCodeWithTypes (below). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ImagingProcedure(FhirR4CodeableConcept modality, FhirR4CodeableConcept anatomy, FhirR4CodeableConcept laterality, RadiologyCodeWithTypes contrast, RadiologyCodeWithTypes view, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Modality = modality;
            Anatomy = anatomy;
            Laterality = laterality;
            Contrast = contrast;
            View = view;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ImagingProcedure"/> for deserialization. </summary>
        internal ImagingProcedure()
        {
        }

        /// <summary> Modality : SNOMED CT code. </summary>
        public FhirR4CodeableConcept Modality { get; }
        /// <summary> Anatomy : SNOMED CT code. </summary>
        public FhirR4CodeableConcept Anatomy { get; }
        /// <summary> Laterality : SNOMED CT code. </summary>
        public FhirR4CodeableConcept Laterality { get; }
        /// <summary> Contrast : see RadiologyCodeWithTypes (below). </summary>
        public RadiologyCodeWithTypes Contrast { get; }
        /// <summary> View : see RadiologyCodeWithTypes (below). </summary>
        public RadiologyCodeWithTypes View { get; }
    }
}
