// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.RadiologyInsights
{
    public partial class ImagingProcedure : IUtf8JsonSerializable, IJsonModel<ImagingProcedure>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ImagingProcedure>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ImagingProcedure>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImagingProcedure>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImagingProcedure)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("modality"u8);
            writer.WriteObjectValue(Modality, options);
            writer.WritePropertyName("anatomy"u8);
            writer.WriteObjectValue(Anatomy, options);
            if (Optional.IsDefined(Laterality))
            {
                writer.WritePropertyName("laterality"u8);
                writer.WriteObjectValue(Laterality, options);
            }
            if (Optional.IsDefined(Contrast))
            {
                writer.WritePropertyName("contrast"u8);
                writer.WriteObjectValue(Contrast, options);
            }
            if (Optional.IsDefined(View))
            {
                writer.WritePropertyName("view"u8);
                writer.WriteObjectValue(View, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ImagingProcedure IJsonModel<ImagingProcedure>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImagingProcedure>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ImagingProcedure)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeImagingProcedure(document.RootElement, options);
        }

        internal static ImagingProcedure DeserializeImagingProcedure(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FhirR4CodeableConcept modality = default;
            FhirR4CodeableConcept anatomy = default;
            FhirR4CodeableConcept laterality = default;
            RadiologyCodeWithTypes contrast = default;
            RadiologyCodeWithTypes view = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("modality"u8))
                {
                    modality = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("anatomy"u8))
                {
                    anatomy = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("laterality"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    laterality = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("contrast"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    contrast = RadiologyCodeWithTypes.DeserializeRadiologyCodeWithTypes(property.Value, options);
                    continue;
                }
                if (property.NameEquals("view"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    view = RadiologyCodeWithTypes.DeserializeRadiologyCodeWithTypes(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ImagingProcedure(
                modality,
                anatomy,
                laterality,
                contrast,
                view,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ImagingProcedure>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImagingProcedure>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ImagingProcedure)} does not support writing '{options.Format}' format.");
            }
        }

        ImagingProcedure IPersistableModel<ImagingProcedure>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ImagingProcedure>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeImagingProcedure(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ImagingProcedure)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ImagingProcedure>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ImagingProcedure FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeImagingProcedure(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
