// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Model factory for models. </summary>
    public static partial class HealthInsightsRadiologyInsightsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RadiologyInsightsJob"/>. </summary>
        /// <param name="jobData"> The request data for the operation. </param>
        /// <param name="result"> The result of the operation. </param>
        /// <param name="id"> The unique ID of the job. </param>
        /// <param name="status"> The status of the job. </param>
        /// <param name="createdAt"> The date and time when the processing job was created. </param>
        /// <param name="expiresAt"> The date and time when the processing job is set to expire. </param>
        /// <param name="updatedAt"> The date and time when the processing job was last updated. </param>
        /// <param name="error"> Error object that describes the error when status is "Failed". </param>
        /// <returns> A new <see cref="RadiologyInsights.RadiologyInsightsJob"/> instance for mocking. </returns>
        public static RadiologyInsightsJob RadiologyInsightsJob(RadiologyInsightsData jobData = null, RadiologyInsightsInferenceResult result = null, string id = null, JobStatus status = default, DateTimeOffset? createdAt = null, DateTimeOffset? expiresAt = null, DateTimeOffset? updatedAt = null, ResponseError error = null)
        {
            return new RadiologyInsightsJob(
                jobData,
                result,
                id,
                status,
                createdAt,
                expiresAt,
                updatedAt,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RadiologyInsightsInferenceResult"/>. </summary>
        /// <param name="patientResults"> Results for the patients given in the request. </param>
        /// <param name="modelVersion"> The version of the model used for inference, expressed as the model date. </param>
        /// <returns> A new <see cref="RadiologyInsights.RadiologyInsightsInferenceResult"/> instance for mocking. </returns>
        public static RadiologyInsightsInferenceResult RadiologyInsightsInferenceResult(IEnumerable<RadiologyInsightsPatientResult> patientResults = null, string modelVersion = null)
        {
            patientResults ??= new List<RadiologyInsightsPatientResult>();

            return new RadiologyInsightsInferenceResult(patientResults?.ToList(), modelVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RadiologyInsightsPatientResult"/>. </summary>
        /// <param name="patientId"> Identifier given for the patient in the request. </param>
        /// <param name="inferences">
        /// The model's inferences for the given patient.
        /// Please note <see cref="RadiologyInsights.RadiologyInsightsInference"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RadiologyInsights.AgeMismatchInference"/>, <see cref="RadiologyInsights.CompleteOrderDiscrepancyInference"/>, <see cref="RadiologyInsights.CriticalResultInference"/>, <see cref="RadiologyInsights.FindingInference"/>, <see cref="RadiologyInsights.FollowupCommunicationInference"/>, <see cref="RadiologyInsights.FollowupRecommendationInference"/>, <see cref="RadiologyInsights.LateralityDiscrepancyInference"/>, <see cref="RadiologyInsights.LimitedOrderDiscrepancyInference"/>, <see cref="RadiologyInsights.RadiologyProcedureInference"/> and <see cref="RadiologyInsights.SexMismatchInference"/>.
        /// </param>
        /// <returns> A new <see cref="RadiologyInsights.RadiologyInsightsPatientResult"/> instance for mocking. </returns>
        public static RadiologyInsightsPatientResult RadiologyInsightsPatientResult(string patientId = null, IEnumerable<RadiologyInsightsInference> inferences = null)
        {
            inferences ??= new List<RadiologyInsightsInference>();

            return new RadiologyInsightsPatientResult(patientId, inferences?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RadiologyInsightsInference"/>. </summary>
        /// <param name="kind"> Discriminator property for RadiologyInsightsInference. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <returns> A new <see cref="RadiologyInsights.RadiologyInsightsInference"/> instance for mocking. </returns>
        public static RadiologyInsightsInference RadiologyInsightsInference(string kind = null, IEnumerable<FhirR4Extension> extension = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new UnknownRadiologyInsightsInference(kind == null ? default : new RadiologyInsightsInferenceType(kind), extension?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.AgeMismatchInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <returns> A new <see cref="RadiologyInsights.AgeMismatchInference"/> instance for mocking. </returns>
        public static AgeMismatchInference AgeMismatchInference(IEnumerable<FhirR4Extension> extension = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new AgeMismatchInference(RadiologyInsightsInferenceType.AgeMismatch, extension?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.SexMismatchInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="sexIndication"> Sex indication : SNOMED CT code for gender finding. </param>
        /// <returns> A new <see cref="RadiologyInsights.SexMismatchInference"/> instance for mocking. </returns>
        public static SexMismatchInference SexMismatchInference(IEnumerable<FhirR4Extension> extension = null, FhirR4CodeableConcept sexIndication = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new SexMismatchInference(RadiologyInsightsInferenceType.SexMismatch, extension?.ToList(), serializedAdditionalRawData: null, sexIndication);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.LateralityDiscrepancyInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="lateralityIndication"> Laterality indication : SNOMED CT code for laterality qualifier value. </param>
        /// <param name="discrepancyType"> Mismatch type : orderLateralityMismatch, textLateralityContradiction, textLateralityMissing. </param>
        /// <returns> A new <see cref="RadiologyInsights.LateralityDiscrepancyInference"/> instance for mocking. </returns>
        public static LateralityDiscrepancyInference LateralityDiscrepancyInference(IEnumerable<FhirR4Extension> extension = null, FhirR4CodeableConcept lateralityIndication = null, LateralityDiscrepancyType discrepancyType = default)
        {
            extension ??= new List<FhirR4Extension>();

            return new LateralityDiscrepancyInference(RadiologyInsightsInferenceType.LateralityDiscrepancy, extension?.ToList(), serializedAdditionalRawData: null, lateralityIndication, discrepancyType);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.CompleteOrderDiscrepancyInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="orderType"> Order type : CPT ultrasound complete code for abdomen, retroperitoneal, pelvis or breast. </param>
        /// <param name="missingBodyParts"> List of missing body parts required by a complete order : SNOMED CT codes. </param>
        /// <param name="missingBodyPartMeasurements"> List of missing body parts that require measurement by a complete order : SNOMED CT codes. </param>
        /// <returns> A new <see cref="RadiologyInsights.CompleteOrderDiscrepancyInference"/> instance for mocking. </returns>
        public static CompleteOrderDiscrepancyInference CompleteOrderDiscrepancyInference(IEnumerable<FhirR4Extension> extension = null, FhirR4CodeableConcept orderType = null, IEnumerable<FhirR4CodeableConcept> missingBodyParts = null, IEnumerable<FhirR4CodeableConcept> missingBodyPartMeasurements = null)
        {
            extension ??= new List<FhirR4Extension>();
            missingBodyParts ??= new List<FhirR4CodeableConcept>();
            missingBodyPartMeasurements ??= new List<FhirR4CodeableConcept>();

            return new CompleteOrderDiscrepancyInference(
                RadiologyInsightsInferenceType.CompleteOrderDiscrepancy,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                orderType,
                missingBodyParts?.ToList(),
                missingBodyPartMeasurements?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.LimitedOrderDiscrepancyInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="orderType"> Order type : CPT ultrasound complete code for abdomen, retroperitoneal, pelvis or breast. </param>
        /// <param name="presentBodyParts"> List of body parts found in the document : SNOMED CT codes. </param>
        /// <param name="presentBodyPartMeasurements"> List of body parts that are measured according to the document : SNOMED CT codes. </param>
        /// <returns> A new <see cref="RadiologyInsights.LimitedOrderDiscrepancyInference"/> instance for mocking. </returns>
        public static LimitedOrderDiscrepancyInference LimitedOrderDiscrepancyInference(IEnumerable<FhirR4Extension> extension = null, FhirR4CodeableConcept orderType = null, IEnumerable<FhirR4CodeableConcept> presentBodyParts = null, IEnumerable<FhirR4CodeableConcept> presentBodyPartMeasurements = null)
        {
            extension ??= new List<FhirR4Extension>();
            presentBodyParts ??= new List<FhirR4CodeableConcept>();
            presentBodyPartMeasurements ??= new List<FhirR4CodeableConcept>();

            return new LimitedOrderDiscrepancyInference(
                RadiologyInsightsInferenceType.LimitedOrderDiscrepancy,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                orderType,
                presentBodyParts?.ToList(),
                presentBodyPartMeasurements?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FindingInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="finding"> Finding data : contains extensions, fields and components linked with the finding. </param>
        /// <returns> A new <see cref="RadiologyInsights.FindingInference"/> instance for mocking. </returns>
        public static FindingInference FindingInference(IEnumerable<FhirR4Extension> extension = null, FhirR4Observation finding = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new FindingInference(RadiologyInsightsInferenceType.Finding, extension?.ToList(), serializedAdditionalRawData: null, finding);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4Observation"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="text"> Text summary of the resource, for human interpretation. </param>
        /// <param name="contained"> Contained, inline Resources. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="modifierExtension"> Extensions that cannot be ignored. </param>
        /// <param name="identifier"> Business Identifier for observation. </param>
        /// <param name="status"> registered | preliminary | final | amended +. </param>
        /// <param name="category"> Classification of  type of observation. </param>
        /// <param name="code"> Type of observation (code / type). </param>
        /// <param name="subject"> Who and/or what the observation is about. </param>
        /// <param name="encounter"> Healthcare event during which this observation is made. </param>
        /// <param name="effectiveDateTime"> Clinically relevant time/time-period for observation. </param>
        /// <param name="effectivePeriod"> Clinically relevant time/time-period for observation. </param>
        /// <param name="effectiveInstant"> Clinically relevant time/time-period for observation. </param>
        /// <param name="issued"> Date/Time this version was made available. </param>
        /// <param name="valueQuantity"> Actual result. </param>
        /// <param name="valueCodeableConcept"> Actual result. </param>
        /// <param name="valueString"> Actual result. </param>
        /// <param name="valueBoolean"> Actual result. </param>
        /// <param name="valueInteger"> Actual result. </param>
        /// <param name="valueRange"> Actual result. </param>
        /// <param name="valueRatio"> Actual result. </param>
        /// <param name="valueSampledData"> Actual result. </param>
        /// <param name="valueTime"> Actual result. </param>
        /// <param name="valueDateTime"> Actual result. </param>
        /// <param name="valuePeriod"> Actual result. </param>
        /// <param name="dataAbsentReason"> Why the result is missing. </param>
        /// <param name="interpretation"> High, low, normal, etc. </param>
        /// <param name="note"> Comments about the observation. </param>
        /// <param name="bodySite"> Observed body part. </param>
        /// <param name="method"> How it was done. </param>
        /// <param name="referenceRange"> Provides guide for interpretation. </param>
        /// <param name="hasMember"> Related resource that belongs to the Observation group. </param>
        /// <param name="derivedFrom"> Related measurements the observation is made from. </param>
        /// <param name="component"> Component results. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4Observation"/> instance for mocking. </returns>
        public static FhirR4Observation FhirR4Observation(string id = null, FhirR4Meta meta = null, string implicitRules = null, string language = null, IDictionary<string, BinaryData> additionalProperties = null, FhirR4Narrative text = null, IEnumerable<FhirR4Resource> contained = null, IEnumerable<FhirR4Extension> extension = null, IEnumerable<FhirR4Extension> modifierExtension = null, IEnumerable<FhirR4Identifier> identifier = null, ObservationStatusCodeType status = default, IEnumerable<FhirR4CodeableConcept> category = null, FhirR4CodeableConcept code = null, FhirR4Reference subject = null, FhirR4Reference encounter = null, string effectiveDateTime = null, FhirR4Period effectivePeriod = null, string effectiveInstant = null, string issued = null, FhirR4Quantity valueQuantity = null, FhirR4CodeableConcept valueCodeableConcept = null, string valueString = null, bool? valueBoolean = null, int? valueInteger = null, FhirR4Range valueRange = null, FhirR4Ratio valueRatio = null, FhirR4SampledData valueSampledData = null, TimeSpan? valueTime = null, string valueDateTime = null, FhirR4Period valuePeriod = null, FhirR4CodeableConcept dataAbsentReason = null, IEnumerable<FhirR4CodeableConcept> interpretation = null, IEnumerable<FhirR4Annotation> note = null, FhirR4CodeableConcept bodySite = null, FhirR4CodeableConcept method = null, IEnumerable<FhirR4ObservationReferenceRange> referenceRange = null, IEnumerable<FhirR4Reference> hasMember = null, IEnumerable<FhirR4Reference> derivedFrom = null, IEnumerable<FhirR4ObservationComponent> component = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            contained ??= new List<FhirR4Resource>();
            extension ??= new List<FhirR4Extension>();
            modifierExtension ??= new List<FhirR4Extension>();
            identifier ??= new List<FhirR4Identifier>();
            category ??= new List<FhirR4CodeableConcept>();
            interpretation ??= new List<FhirR4CodeableConcept>();
            note ??= new List<FhirR4Annotation>();
            referenceRange ??= new List<FhirR4ObservationReferenceRange>();
            hasMember ??= new List<FhirR4Reference>();
            derivedFrom ??= new List<FhirR4Reference>();
            component ??= new List<FhirR4ObservationComponent>();

            return new FhirR4Observation(
                "Observation",
                id,
                meta,
                implicitRules,
                language,
                additionalProperties,
                text,
                contained?.ToList(),
                extension?.ToList(),
                modifierExtension?.ToList(),
                identifier?.ToList(),
                status,
                category?.ToList(),
                code,
                subject,
                encounter,
                effectiveDateTime,
                effectivePeriod,
                effectiveInstant,
                issued,
                valueQuantity,
                valueCodeableConcept,
                valueString,
                valueBoolean,
                valueInteger,
                valueRange,
                valueRatio,
                valueSampledData,
                valueTime,
                valueDateTime,
                valuePeriod,
                dataAbsentReason,
                interpretation?.ToList(),
                note?.ToList(),
                bodySite,
                method,
                referenceRange?.ToList(),
                hasMember?.ToList(),
                derivedFrom?.ToList(),
                component?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4Annotation"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="authorString"> Individual responsible for the annotation. </param>
        /// <param name="time"> When the annotation was made. </param>
        /// <param name="text"> The annotation - text content (as markdown). </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4Annotation"/> instance for mocking. </returns>
        public static FhirR4Annotation FhirR4Annotation(string id = null, IEnumerable<FhirR4Extension> extension = null, string authorString = null, string time = null, string text = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new FhirR4Annotation(
                id,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                authorString,
                time,
                text);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4ObservationReferenceRange"/>. </summary>
        /// <param name="low"> Low Range, if relevant. </param>
        /// <param name="high"> High Range, if relevant. </param>
        /// <param name="type"> Reference range qualifier. </param>
        /// <param name="appliesTo"> Reference range population. </param>
        /// <param name="age"> Applicable age range, if relevant. </param>
        /// <param name="text"> Text based reference range in an observation. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4ObservationReferenceRange"/> instance for mocking. </returns>
        public static FhirR4ObservationReferenceRange FhirR4ObservationReferenceRange(FhirR4Quantity low = null, FhirR4Quantity high = null, FhirR4CodeableConcept type = null, IEnumerable<FhirR4CodeableConcept> appliesTo = null, FhirR4Range age = null, string text = null)
        {
            appliesTo ??= new List<FhirR4CodeableConcept>();

            return new FhirR4ObservationReferenceRange(
                low,
                high,
                type,
                appliesTo?.ToList(),
                age,
                text,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4ObservationComponent"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="code"> Type of component observation (code / type). </param>
        /// <param name="valueQuantity"> Value as Quantity. </param>
        /// <param name="valueCodeableConcept"> Value as CodeableConcept. </param>
        /// <param name="valueString"> Value as string. </param>
        /// <param name="valueBoolean"> Value as boolean. </param>
        /// <param name="valueInteger"> Value as integer. </param>
        /// <param name="valueRange"> Value as Range. </param>
        /// <param name="valueRatio"> Value as Ratio. </param>
        /// <param name="valueSampledData"> Value as SampledData. </param>
        /// <param name="valueTime"> Value as time (hh:mm:ss). </param>
        /// <param name="valueDateTime"> Value as dateTime. </param>
        /// <param name="valuePeriod"> Value as Period. </param>
        /// <param name="valueReference"> Value as reference. </param>
        /// <param name="dataAbsentReason"> Why the component result is missing. </param>
        /// <param name="interpretation"> High, low, normal, etc. </param>
        /// <param name="referenceRange"> Provides guide for interpretation of component result. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4ObservationComponent"/> instance for mocking. </returns>
        public static FhirR4ObservationComponent FhirR4ObservationComponent(string id = null, IEnumerable<FhirR4Extension> extension = null, FhirR4CodeableConcept code = null, FhirR4Quantity valueQuantity = null, FhirR4CodeableConcept valueCodeableConcept = null, string valueString = null, bool? valueBoolean = null, int? valueInteger = null, FhirR4Range valueRange = null, FhirR4Ratio valueRatio = null, FhirR4SampledData valueSampledData = null, TimeSpan? valueTime = null, string valueDateTime = null, FhirR4Period valuePeriod = null, FhirR4Reference valueReference = null, FhirR4CodeableConcept dataAbsentReason = null, IEnumerable<FhirR4CodeableConcept> interpretation = null, IEnumerable<FhirR4ObservationReferenceRange> referenceRange = null)
        {
            extension ??= new List<FhirR4Extension>();
            interpretation ??= new List<FhirR4CodeableConcept>();
            referenceRange ??= new List<FhirR4ObservationReferenceRange>();

            return new FhirR4ObservationComponent(
                id,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                code,
                valueQuantity,
                valueCodeableConcept,
                valueString,
                valueBoolean,
                valueInteger,
                valueRange,
                valueRatio,
                valueSampledData,
                valueTime,
                valueDateTime,
                valuePeriod,
                valueReference,
                dataAbsentReason,
                interpretation?.ToList(),
                referenceRange?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4DomainResource"/>. </summary>
        /// <param name="resourceType"> The type of resource. </param>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="text"> Text summary of the resource, for human interpretation. </param>
        /// <param name="contained"> Contained, inline Resources. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="modifierExtension"> Extensions that cannot be ignored. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4DomainResource"/> instance for mocking. </returns>
        public static FhirR4DomainResource FhirR4DomainResource(string resourceType = null, string id = null, FhirR4Meta meta = null, string implicitRules = null, string language = null, IDictionary<string, BinaryData> additionalProperties = null, FhirR4Narrative text = null, IEnumerable<FhirR4Resource> contained = null, IEnumerable<FhirR4Extension> extension = null, IEnumerable<FhirR4Extension> modifierExtension = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            contained ??= new List<FhirR4Resource>();
            extension ??= new List<FhirR4Extension>();
            modifierExtension ??= new List<FhirR4Extension>();

            return new UnknownFhirR4DomainResource(
                resourceType,
                id,
                meta,
                implicitRules,
                language,
                additionalProperties,
                text,
                contained?.ToList(),
                extension?.ToList(),
                modifierExtension?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4Narrative"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="status"> generated, extensions, additional, empty. </param>
        /// <param name="div"> xhtml. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4Narrative"/> instance for mocking. </returns>
        public static FhirR4Narrative FhirR4Narrative(string id = null, IEnumerable<FhirR4Extension> extension = null, string status = null, string div = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new FhirR4Narrative(id, extension?.ToList(), serializedAdditionalRawData: null, status, div);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4Condition"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="text"> Text summary of the resource, for human interpretation. </param>
        /// <param name="contained"> Contained, inline Resources. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="modifierExtension"> Extensions that cannot be ignored. </param>
        /// <param name="identifier"> External Ids for this condition. </param>
        /// <param name="clinicalStatus"> active | recurrence | relapse | inactive | remission | resolved. </param>
        /// <param name="verificationStatus"> unconfirmed | provisional | differential | confirmed | refuted | entered-in-error. </param>
        /// <param name="category"> problem-list-item | encounter-diagnosis. </param>
        /// <param name="severity"> Subjective severity of condition. </param>
        /// <param name="code"> Identification of the condition, problem or diagnosis. </param>
        /// <param name="bodySite"> Anatomical location, if relevant. </param>
        /// <param name="encounter"> Encounter created as part of. </param>
        /// <param name="onsetDateTime"> Estimated or actual date,  date-time, or age. </param>
        /// <param name="onsetAge"> Estimated or actual date,  date-time, or age. </param>
        /// <param name="onsetPeriod"> Estimated or actual date,  date-time, or age. </param>
        /// <param name="onsetRange"> Estimated or actual date,  date-time, or age. </param>
        /// <param name="onsetString"> Estimated or actual date,  date-time, or age. </param>
        /// <param name="abatementDateTime"> When in resolution/remission. </param>
        /// <param name="abatementAge"> When in resolution/remission. </param>
        /// <param name="abatementPeriod"> When in resolution/remission. </param>
        /// <param name="abatementRange"> When in resolution/remission. </param>
        /// <param name="abatementString"> When in resolution/remission. </param>
        /// <param name="recordedDate"> Date record was first recorded. </param>
        /// <param name="stage"> stge/grade, usually assessed formally. </param>
        /// <param name="note"> Additional information about the Condition. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4Condition"/> instance for mocking. </returns>
        public static FhirR4Condition FhirR4Condition(string id = null, FhirR4Meta meta = null, string implicitRules = null, string language = null, IDictionary<string, BinaryData> additionalProperties = null, FhirR4Narrative text = null, IEnumerable<FhirR4Resource> contained = null, IEnumerable<FhirR4Extension> extension = null, IEnumerable<FhirR4Extension> modifierExtension = null, IEnumerable<FhirR4Identifier> identifier = null, FhirR4CodeableConcept clinicalStatus = null, FhirR4CodeableConcept verificationStatus = null, IEnumerable<FhirR4CodeableConcept> category = null, FhirR4CodeableConcept severity = null, FhirR4CodeableConcept code = null, IEnumerable<FhirR4CodeableConcept> bodySite = null, FhirR4Reference encounter = null, string onsetDateTime = null, FhirR4Quantity onsetAge = null, FhirR4Period onsetPeriod = null, FhirR4Range onsetRange = null, string onsetString = null, string abatementDateTime = null, FhirR4Quantity abatementAge = null, FhirR4Period abatementPeriod = null, FhirR4Range abatementRange = null, string abatementString = null, string recordedDate = null, IEnumerable<FhirR4ConditionStage> stage = null, IEnumerable<FhirR4Annotation> note = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            contained ??= new List<FhirR4Resource>();
            extension ??= new List<FhirR4Extension>();
            modifierExtension ??= new List<FhirR4Extension>();
            identifier ??= new List<FhirR4Identifier>();
            category ??= new List<FhirR4CodeableConcept>();
            bodySite ??= new List<FhirR4CodeableConcept>();
            stage ??= new List<FhirR4ConditionStage>();
            note ??= new List<FhirR4Annotation>();

            return new FhirR4Condition(
                "Condition",
                id,
                meta,
                implicitRules,
                language,
                additionalProperties,
                text,
                contained?.ToList(),
                extension?.ToList(),
                modifierExtension?.ToList(),
                identifier?.ToList(),
                clinicalStatus,
                verificationStatus,
                category?.ToList(),
                severity,
                code,
                bodySite?.ToList(),
                encounter,
                onsetDateTime,
                onsetAge,
                onsetPeriod,
                onsetRange,
                onsetString,
                abatementDateTime,
                abatementAge,
                abatementPeriod,
                abatementRange,
                abatementString,
                recordedDate,
                stage?.ToList(),
                note?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4ConditionStage"/>. </summary>
        /// <param name="summary"> Simple summary (disease specific). </param>
        /// <param name="type"> Kind of staging. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4ConditionStage"/> instance for mocking. </returns>
        public static FhirR4ConditionStage FhirR4ConditionStage(FhirR4CodeableConcept summary = null, FhirR4CodeableConcept type = null)
        {
            return new FhirR4ConditionStage(summary, type, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4ResearchStudy"/>. </summary>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="text"> Text summary of the resource, for human interpretation. </param>
        /// <param name="contained"> Contained, inline Resources. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="modifierExtension"> Extensions that cannot be ignored. </param>
        /// <param name="identifier"> Business Identifier for study. </param>
        /// <param name="title"> Name for this study. </param>
        /// <param name="protocol"> Steps followed in executing study. </param>
        /// <param name="partOf"> Part of larger study. </param>
        /// <param name="status"> active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn. </param>
        /// <param name="primaryPurposeType"> treatment | prevention | diagnostic | supportive-care | screening | health-services-research | basic-science | device-feasibility. </param>
        /// <param name="phase"> n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 | phase-3 | phase-4. </param>
        /// <param name="category"> Classifications for the study. </param>
        /// <param name="focus"> Drugs, devices, etc. under study. </param>
        /// <param name="condition"> Condition being studied. </param>
        /// <param name="contact"> Contact details for the study. </param>
        /// <param name="keyword"> Used to search for the study. </param>
        /// <param name="location"> Geographic region(s) for study. </param>
        /// <param name="description"> What this is study doing. </param>
        /// <param name="enrollment"> Inclusion &amp; exclusion criteria. </param>
        /// <param name="period"> When the study began and ended. </param>
        /// <param name="sponsor"> Organization that initiates and is legally responsible for the study. </param>
        /// <param name="principalInvestigator"> Researcher who oversees multiple aspects of the study. </param>
        /// <param name="site"> Facility where study activities are conducted. </param>
        /// <param name="reasonStopped"> accrual-goal-met | closed-due-to-toxicity | closed-due-to-lack-of-study-progress | temporarily-closed-per-study-design. </param>
        /// <param name="note"> Comments made about the study. </param>
        /// <param name="arm"> Defined path through the study for a subject. </param>
        /// <param name="objective"> A goal for the study. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4ResearchStudy"/> instance for mocking. </returns>
        public static FhirR4ResearchStudy FhirR4ResearchStudy(string id = null, FhirR4Meta meta = null, string implicitRules = null, string language = null, IDictionary<string, BinaryData> additionalProperties = null, FhirR4Narrative text = null, IEnumerable<FhirR4Resource> contained = null, IEnumerable<FhirR4Extension> extension = null, IEnumerable<FhirR4Extension> modifierExtension = null, IEnumerable<FhirR4Identifier> identifier = null, string title = null, IEnumerable<FhirR4Reference> protocol = null, IEnumerable<FhirR4Reference> partOf = null, ResearchStudyStatusCodeType status = default, FhirR4CodeableConcept primaryPurposeType = null, FhirR4CodeableConcept phase = null, IEnumerable<FhirR4CodeableConcept> category = null, IEnumerable<FhirR4CodeableConcept> focus = null, IEnumerable<FhirR4CodeableConcept> condition = null, IEnumerable<FhirR4ContactDetail> contact = null, IEnumerable<FhirR4CodeableConcept> keyword = null, IEnumerable<FhirR4CodeableConcept> location = null, string description = null, IEnumerable<FhirR4Reference> enrollment = null, FhirR4Period period = null, FhirR4Reference sponsor = null, FhirR4Reference principalInvestigator = null, IEnumerable<FhirR4Reference> site = null, FhirR4CodeableConcept reasonStopped = null, IEnumerable<FhirR4Annotation> note = null, IEnumerable<ResearchStudyArm> arm = null, IEnumerable<ResearchStudyObjective> objective = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();
            contained ??= new List<FhirR4Resource>();
            extension ??= new List<FhirR4Extension>();
            modifierExtension ??= new List<FhirR4Extension>();
            identifier ??= new List<FhirR4Identifier>();
            protocol ??= new List<FhirR4Reference>();
            partOf ??= new List<FhirR4Reference>();
            category ??= new List<FhirR4CodeableConcept>();
            focus ??= new List<FhirR4CodeableConcept>();
            condition ??= new List<FhirR4CodeableConcept>();
            contact ??= new List<FhirR4ContactDetail>();
            keyword ??= new List<FhirR4CodeableConcept>();
            location ??= new List<FhirR4CodeableConcept>();
            enrollment ??= new List<FhirR4Reference>();
            site ??= new List<FhirR4Reference>();
            note ??= new List<FhirR4Annotation>();
            arm ??= new List<ResearchStudyArm>();
            objective ??= new List<ResearchStudyObjective>();

            return new FhirR4ResearchStudy(
                "ResearchStudy",
                id,
                meta,
                implicitRules,
                language,
                additionalProperties,
                text,
                contained?.ToList(),
                extension?.ToList(),
                modifierExtension?.ToList(),
                identifier?.ToList(),
                title,
                protocol?.ToList(),
                partOf?.ToList(),
                status,
                primaryPurposeType,
                phase,
                category?.ToList(),
                focus?.ToList(),
                condition?.ToList(),
                contact?.ToList(),
                keyword?.ToList(),
                location?.ToList(),
                description,
                enrollment?.ToList(),
                period,
                sponsor,
                principalInvestigator,
                site?.ToList(),
                reasonStopped,
                note?.ToList(),
                arm?.ToList(),
                objective?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4ContactDetail"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="name"> Name of an individual to contact. </param>
        /// <param name="telecom"> Contact details for individual or organization. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4ContactDetail"/> instance for mocking. </returns>
        public static FhirR4ContactDetail FhirR4ContactDetail(string id = null, IEnumerable<FhirR4Extension> extension = null, string name = null, IEnumerable<FhirR4ContactPoint> telecom = null)
        {
            extension ??= new List<FhirR4Extension>();
            telecom ??= new List<FhirR4ContactPoint>();

            return new FhirR4ContactDetail(id, extension?.ToList(), serializedAdditionalRawData: null, name, telecom?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FhirR4ContactPoint"/>. </summary>
        /// <param name="system"> phone | fax | email | pager | url | sms | other. </param>
        /// <param name="value"> The actual contact point details. </param>
        /// <param name="use"> home | work | temp | old | mobile - purpose of this contact point. </param>
        /// <param name="rank"> Specify preferred order of use (1 = highest). </param>
        /// <param name="period"> Time period when the contact point was/is in use. </param>
        /// <returns> A new <see cref="RadiologyInsights.FhirR4ContactPoint"/> instance for mocking. </returns>
        public static FhirR4ContactPoint FhirR4ContactPoint(ContactPointSystem? system = null, string value = null, ContactPointUse? use = null, int? rank = null, FhirR4Period period = null)
        {
            return new FhirR4ContactPoint(
                system,
                value,
                use,
                rank,
                period,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.ResearchStudyArm"/>. </summary>
        /// <param name="name"> Label for study arm. </param>
        /// <param name="type"> Categorization of study arm. </param>
        /// <param name="description"> Short explanation of study path. </param>
        /// <returns> A new <see cref="RadiologyInsights.ResearchStudyArm"/> instance for mocking. </returns>
        public static ResearchStudyArm ResearchStudyArm(string name = null, FhirR4CodeableConcept type = null, string description = null)
        {
            return new ResearchStudyArm(name, type, description, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.ResearchStudyObjective"/>. </summary>
        /// <param name="name"> Label for the objective. </param>
        /// <param name="type"> primary | secondary | exploratory. </param>
        /// <returns> A new <see cref="RadiologyInsights.ResearchStudyObjective"/> instance for mocking. </returns>
        public static ResearchStudyObjective ResearchStudyObjective(string name = null, FhirR4CodeableConcept type = null)
        {
            return new ResearchStudyObjective(name, type, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.CriticalResultInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="result"> The complete Critical Result, as outlined below, will be reused for the recommendation. </param>
        /// <returns> A new <see cref="RadiologyInsights.CriticalResultInference"/> instance for mocking. </returns>
        public static CriticalResultInference CriticalResultInference(IEnumerable<FhirR4Extension> extension = null, CriticalResult result = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new CriticalResultInference(RadiologyInsightsInferenceType.CriticalResult, extension?.ToList(), serializedAdditionalRawData: null, result);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.CriticalResult"/>. </summary>
        /// <param name="description"> Description : medical problem. </param>
        /// <param name="finding"> Finding linked to the critical result. </param>
        /// <returns> A new <see cref="RadiologyInsights.CriticalResult"/> instance for mocking. </returns>
        public static CriticalResult CriticalResult(string description = null, FhirR4Observation finding = null)
        {
            return new CriticalResult(description, finding, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RadiologyProcedureInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="procedureCodes"> LOINC codes for the procedure. </param>
        /// <param name="imagingProcedures"> Imaging procedures. </param>
        /// <param name="orderedProcedure"> Ordered procedure information from the document information or text. </param>
        /// <returns> A new <see cref="RadiologyInsights.RadiologyProcedureInference"/> instance for mocking. </returns>
        public static RadiologyProcedureInference RadiologyProcedureInference(IEnumerable<FhirR4Extension> extension = null, IEnumerable<FhirR4CodeableConcept> procedureCodes = null, IEnumerable<ImagingProcedure> imagingProcedures = null, OrderedProcedure orderedProcedure = null)
        {
            extension ??= new List<FhirR4Extension>();
            procedureCodes ??= new List<FhirR4CodeableConcept>();
            imagingProcedures ??= new List<ImagingProcedure>();

            return new RadiologyProcedureInference(
                RadiologyInsightsInferenceType.RadiologyProcedure,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                procedureCodes?.ToList(),
                imagingProcedures?.ToList(),
                orderedProcedure);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.ImagingProcedure"/>. </summary>
        /// <param name="modality"> Modality : SNOMED CT code. </param>
        /// <param name="anatomy"> Anatomy : SNOMED CT code. </param>
        /// <param name="laterality"> Laterality : SNOMED CT code. </param>
        /// <param name="contrast"> Contrast : see RadiologyCodeWithTypes (below). </param>
        /// <param name="view"> View : see RadiologyCodeWithTypes (below). </param>
        /// <returns> A new <see cref="RadiologyInsights.ImagingProcedure"/> instance for mocking. </returns>
        public static ImagingProcedure ImagingProcedure(FhirR4CodeableConcept modality = null, FhirR4CodeableConcept anatomy = null, FhirR4CodeableConcept laterality = null, RadiologyCodeWithTypes contrast = null, RadiologyCodeWithTypes view = null)
        {
            return new ImagingProcedure(
                modality,
                anatomy,
                laterality,
                contrast,
                view,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RadiologyCodeWithTypes"/>. </summary>
        /// <param name="code"> The SNOMED CT code indicates whether imaging was conducted with or without contrast in the case of contrast, and in the case of views, it denotes the number of views. </param>
        /// <param name="types"> The collection of types will indicate the contrast substance used in the case of contrast and, in the case of views, it will specify the types of views, such as lateral and frontal, etc. </param>
        /// <returns> A new <see cref="RadiologyInsights.RadiologyCodeWithTypes"/> instance for mocking. </returns>
        public static RadiologyCodeWithTypes RadiologyCodeWithTypes(FhirR4CodeableConcept code = null, IEnumerable<FhirR4CodeableConcept> types = null)
        {
            types ??= new List<FhirR4CodeableConcept>();

            return new RadiologyCodeWithTypes(code, types?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FollowupRecommendationInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="effectiveAt"> Date and time are displayed when the procedure is recommended to be done at a specific point in time. </param>
        /// <param name="effectivePeriod"> The period is shown if a specific period is mentioned, with a start and end date-time. </param>
        /// <param name="findings"> Findings related to the recommendation. </param>
        /// <param name="isConditional"> The conditional value indicates whether or not the sentence containing the recommendation includes a conditional statement. Keywords for conditional statements include 'if', 'when', 'unless', and so on. </param>
        /// <param name="isOption"> The option value indicates whether or not the sentence containing the recommendation includes an optional statement. Keywords for optional statements include 'recommend', 'consider', and so on. </param>
        /// <param name="isGuideline"> The guideline value indicates whether or not the recommendation is part of a guideline section that compiles all recommendations applicable to various findings. </param>
        /// <param name="isHedging"> Hedging refers to ambiguous, vague or imprecise language within the sentence of the recommendation. Keywords for hedging are 'can be','may be',and so on. </param>
        /// <param name="recommendedProcedure">
        /// The procedure recommendation can be a generic procedure or an imaging procedure.
        /// Please note <see cref="RadiologyInsights.ProcedureRecommendation"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RadiologyInsights.GenericProcedureRecommendation"/> and <see cref="RadiologyInsights.ImagingProcedureRecommendation"/>.
        /// </param>
        /// <returns> A new <see cref="RadiologyInsights.FollowupRecommendationInference"/> instance for mocking. </returns>
        public static FollowupRecommendationInference FollowupRecommendationInference(IEnumerable<FhirR4Extension> extension = null, string effectiveAt = null, FhirR4Period effectivePeriod = null, IEnumerable<RecommendationFinding> findings = null, bool isConditional = default, bool isOption = default, bool isGuideline = default, bool isHedging = default, ProcedureRecommendation recommendedProcedure = null)
        {
            extension ??= new List<FhirR4Extension>();
            findings ??= new List<RecommendationFinding>();

            return new FollowupRecommendationInference(
                RadiologyInsightsInferenceType.FollowupRecommendation,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                effectiveAt,
                effectivePeriod,
                findings?.ToList(),
                isConditional,
                isOption,
                isGuideline,
                isHedging,
                recommendedProcedure);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.RecommendationFinding"/>. </summary>
        /// <param name="finding"> Finding linked to a recommendation. </param>
        /// <param name="criticalFinding"> Critical result linked to a recommendation. </param>
        /// <param name="recommendationFindingStatus"> Recommendation finding status. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <returns> A new <see cref="RadiologyInsights.RecommendationFinding"/> instance for mocking. </returns>
        public static RecommendationFinding RecommendationFinding(FhirR4Observation finding = null, CriticalResult criticalFinding = null, RecommendationFindingStatusType recommendationFindingStatus = default, IEnumerable<FhirR4Extension> extension = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new RecommendationFinding(finding, criticalFinding, recommendationFindingStatus, extension?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.ProcedureRecommendation"/>. </summary>
        /// <param name="kind"> Discriminator property for ProcedureRecommendation. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <returns> A new <see cref="RadiologyInsights.ProcedureRecommendation"/> instance for mocking. </returns>
        public static ProcedureRecommendation ProcedureRecommendation(string kind = null, IEnumerable<FhirR4Extension> extension = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new UnknownProcedureRecommendation(kind, extension?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.GenericProcedureRecommendation"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="code"> Procedure modality : SNOMED CT code. </param>
        /// <param name="description"> Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION (PROCEDURE) based on SNOMED CT. </param>
        /// <returns> A new <see cref="RadiologyInsights.GenericProcedureRecommendation"/> instance for mocking. </returns>
        public static GenericProcedureRecommendation GenericProcedureRecommendation(IEnumerable<FhirR4Extension> extension = null, FhirR4CodeableConcept code = null, string description = null)
        {
            extension ??= new List<FhirR4Extension>();

            return new GenericProcedureRecommendation("genericProcedureRecommendation", extension?.ToList(), serializedAdditionalRawData: null, code, description);
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.ImagingProcedureRecommendation"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="procedureCodes"> LOINC codes for the procedure. </param>
        /// <param name="imagingProcedures"> Imaging procedures. </param>
        /// <returns> A new <see cref="RadiologyInsights.ImagingProcedureRecommendation"/> instance for mocking. </returns>
        public static ImagingProcedureRecommendation ImagingProcedureRecommendation(IEnumerable<FhirR4Extension> extension = null, IEnumerable<FhirR4CodeableConcept> procedureCodes = null, IEnumerable<ImagingProcedure> imagingProcedures = null)
        {
            extension ??= new List<FhirR4Extension>();
            procedureCodes ??= new List<FhirR4CodeableConcept>();
            imagingProcedures ??= new List<ImagingProcedure>();

            return new ImagingProcedureRecommendation("imagingProcedureRecommendation", extension?.ToList(), serializedAdditionalRawData: null, procedureCodes?.ToList(), imagingProcedures?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="RadiologyInsights.FollowupCommunicationInference"/>. </summary>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="communicatedAt"> Communication date and time. </param>
        /// <param name="recipient"> Recipient of the communication. </param>
        /// <param name="wasAcknowledged"> Communication was acknowledged. </param>
        /// <returns> A new <see cref="RadiologyInsights.FollowupCommunicationInference"/> instance for mocking. </returns>
        public static FollowupCommunicationInference FollowupCommunicationInference(IEnumerable<FhirR4Extension> extension = null, IEnumerable<DateTimeOffset> communicatedAt = null, IEnumerable<MedicalProfessionalType> recipient = null, bool wasAcknowledged = default)
        {
            extension ??= new List<FhirR4Extension>();
            communicatedAt ??= new List<DateTimeOffset>();
            recipient ??= new List<MedicalProfessionalType>();

            return new FollowupCommunicationInference(
                RadiologyInsightsInferenceType.FollowupCommunication,
                extension?.ToList(),
                serializedAdditionalRawData: null,
                communicatedAt?.ToList(),
                recipient?.ToList(),
                wasAcknowledged);
        }
    }
}
