// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Generic procedure information. </summary>
    public partial class GenericProcedureRecommendation : ProcedureRecommendation
    {
        /// <summary> Initializes a new instance of <see cref="GenericProcedureRecommendation"/>. </summary>
        /// <param name="code"> Procedure modality : SNOMED CT code. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="code"/> is null. </exception>
        internal GenericProcedureRecommendation(FhirR4CodeableConcept code)
        {
            Argument.AssertNotNull(code, nameof(code));

            Kind = "genericProcedureRecommendation";
            Code = code;
        }

        /// <summary> Initializes a new instance of <see cref="GenericProcedureRecommendation"/>. </summary>
        /// <param name="kind"> Discriminator property for ProcedureRecommendation. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="code"> Procedure modality : SNOMED CT code. </param>
        /// <param name="description"> Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION (PROCEDURE) based on SNOMED CT. </param>
        internal GenericProcedureRecommendation(string kind, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, FhirR4CodeableConcept code, string description) : base(kind, extension, serializedAdditionalRawData)
        {
            Code = code;
            Description = description;
        }

        /// <summary> Initializes a new instance of <see cref="GenericProcedureRecommendation"/> for deserialization. </summary>
        internal GenericProcedureRecommendation()
        {
        }

        /// <summary> Procedure modality : SNOMED CT code. </summary>
        public FhirR4CodeableConcept Code { get; }
        /// <summary> Procedure description : MANAGEMENT PROCEDURE (PROCEDURE) or CONSULTATION (PROCEDURE) based on SNOMED CT. </summary>
        public string Description { get; }
    }
}
