// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Follow-up recommendation options. </summary>
    public partial class FollowupRecommendationOptions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FollowupRecommendationOptions"/>. </summary>
        public FollowupRecommendationOptions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FollowupRecommendationOptions"/>. </summary>
        /// <param name="includeRecommendationsWithNoSpecifiedModality"> Include/Exclude follow-up recommendations without a specific radiology procedure. Default is false. </param>
        /// <param name="includeRecommendationsInReferences"> Include/Exclude follow-up recommendations in references to a guideline or article. Default is false. </param>
        /// <param name="provideFocusedSentenceEvidence"> If this is true, provide one or more sentences as evidence for the recommendation, next to the token evidence. The start and end positions of these sentences will be put in an extension with url 'modality_sentences'. Default is false. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FollowupRecommendationOptions(bool? includeRecommendationsWithNoSpecifiedModality, bool? includeRecommendationsInReferences, bool? provideFocusedSentenceEvidence, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IncludeRecommendationsWithNoSpecifiedModality = includeRecommendationsWithNoSpecifiedModality;
            IncludeRecommendationsInReferences = includeRecommendationsInReferences;
            ProvideFocusedSentenceEvidence = provideFocusedSentenceEvidence;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Include/Exclude follow-up recommendations without a specific radiology procedure. Default is false. </summary>
        public bool? IncludeRecommendationsWithNoSpecifiedModality { get; set; }
        /// <summary> Include/Exclude follow-up recommendations in references to a guideline or article. Default is false. </summary>
        public bool? IncludeRecommendationsInReferences { get; set; }
        /// <summary> If this is true, provide one or more sentences as evidence for the recommendation, next to the token evidence. The start and end positions of these sentences will be put in an extension with url 'modality_sentences'. Default is false. </summary>
        public bool? ProvideFocusedSentenceEvidence { get; set; }
    }
}
