// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.RadiologyInsights
{
    public partial class FollowupRecommendationInference : IUtf8JsonSerializable, IJsonModel<FollowupRecommendationInference>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FollowupRecommendationInference>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FollowupRecommendationInference>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FollowupRecommendationInference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FollowupRecommendationInference)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(EffectiveAt))
            {
                writer.WritePropertyName("effectiveAt"u8);
                writer.WriteStringValue(EffectiveAt);
            }
            if (Optional.IsDefined(EffectivePeriod))
            {
                writer.WritePropertyName("effectivePeriod"u8);
                writer.WriteObjectValue(EffectivePeriod, options);
            }
            if (Optional.IsCollectionDefined(Findings))
            {
                writer.WritePropertyName("findings"u8);
                writer.WriteStartArray();
                foreach (var item in Findings)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("isConditional"u8);
            writer.WriteBooleanValue(IsConditional);
            writer.WritePropertyName("isOption"u8);
            writer.WriteBooleanValue(IsOption);
            writer.WritePropertyName("isGuideline"u8);
            writer.WriteBooleanValue(IsGuideline);
            writer.WritePropertyName("isHedging"u8);
            writer.WriteBooleanValue(IsHedging);
            writer.WritePropertyName("recommendedProcedure"u8);
            writer.WriteObjectValue(RecommendedProcedure, options);
        }

        FollowupRecommendationInference IJsonModel<FollowupRecommendationInference>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FollowupRecommendationInference>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FollowupRecommendationInference)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFollowupRecommendationInference(document.RootElement, options);
        }

        internal static FollowupRecommendationInference DeserializeFollowupRecommendationInference(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string effectiveAt = default;
            FhirR4Period effectivePeriod = default;
            IReadOnlyList<RecommendationFinding> findings = default;
            bool isConditional = default;
            bool isOption = default;
            bool isGuideline = default;
            bool isHedging = default;
            ProcedureRecommendation recommendedProcedure = default;
            RadiologyInsightsInferenceType kind = default;
            IReadOnlyList<FhirR4Extension> extension = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("effectiveAt"u8))
                {
                    effectiveAt = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("effectivePeriod"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    effectivePeriod = FhirR4Period.DeserializeFhirR4Period(property.Value, options);
                    continue;
                }
                if (property.NameEquals("findings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<RecommendationFinding> array = new List<RecommendationFinding>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(RecommendationFinding.DeserializeRecommendationFinding(item, options));
                    }
                    findings = array;
                    continue;
                }
                if (property.NameEquals("isConditional"u8))
                {
                    isConditional = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isOption"u8))
                {
                    isOption = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isGuideline"u8))
                {
                    isGuideline = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isHedging"u8))
                {
                    isHedging = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("recommendedProcedure"u8))
                {
                    recommendedProcedure = ProcedureRecommendation.DeserializeProcedureRecommendation(property.Value, options);
                    continue;
                }
                if (property.NameEquals("kind"u8))
                {
                    kind = new RadiologyInsightsInferenceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("extension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Extension> array = new List<FhirR4Extension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Extension.DeserializeFhirR4Extension(item, options));
                    }
                    extension = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FollowupRecommendationInference(
                kind,
                extension ?? new ChangeTrackingList<FhirR4Extension>(),
                serializedAdditionalRawData,
                effectiveAt,
                effectivePeriod,
                findings ?? new ChangeTrackingList<RecommendationFinding>(),
                isConditional,
                isOption,
                isGuideline,
                isHedging,
                recommendedProcedure);
        }

        BinaryData IPersistableModel<FollowupRecommendationInference>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FollowupRecommendationInference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FollowupRecommendationInference)} does not support writing '{options.Format}' format.");
            }
        }

        FollowupRecommendationInference IPersistableModel<FollowupRecommendationInference>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FollowupRecommendationInference>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFollowupRecommendationInference(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FollowupRecommendationInference)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FollowupRecommendationInference>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new FollowupRecommendationInference FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFollowupRecommendationInference(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
