// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Follow-up communication involves the exchange of important information, recommendations, or updates between radiologists and other healthcare professionals involved in a patient's care. </summary>
    public partial class FollowupCommunicationInference : RadiologyInsightsInference
    {
        /// <summary> Initializes a new instance of <see cref="FollowupCommunicationInference"/>. </summary>
        /// <param name="wasAcknowledged"> Communication was acknowledged. </param>
        internal FollowupCommunicationInference(bool wasAcknowledged)
        {
            Kind = RadiologyInsightsInferenceType.FollowupCommunication;
            CommunicatedAt = new ChangeTrackingList<DateTimeOffset>();
            Recipient = new ChangeTrackingList<MedicalProfessionalType>();
            WasAcknowledged = wasAcknowledged;
        }

        /// <summary> Initializes a new instance of <see cref="FollowupCommunicationInference"/>. </summary>
        /// <param name="kind"> Discriminator property for RadiologyInsightsInference. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="communicatedAt"> Communication date and time. </param>
        /// <param name="recipient"> Recipient of the communication. </param>
        /// <param name="wasAcknowledged"> Communication was acknowledged. </param>
        internal FollowupCommunicationInference(RadiologyInsightsInferenceType kind, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, IReadOnlyList<DateTimeOffset> communicatedAt, IReadOnlyList<MedicalProfessionalType> recipient, bool wasAcknowledged) : base(kind, extension, serializedAdditionalRawData)
        {
            CommunicatedAt = communicatedAt;
            Recipient = recipient;
            WasAcknowledged = wasAcknowledged;
        }

        /// <summary> Initializes a new instance of <see cref="FollowupCommunicationInference"/> for deserialization. </summary>
        internal FollowupCommunicationInference()
        {
        }

        /// <summary> Communication date and time. </summary>
        public IReadOnlyList<DateTimeOffset> CommunicatedAt { get; }
        /// <summary> Recipient of the communication. </summary>
        public IReadOnlyList<MedicalProfessionalType> Recipient { get; }
        /// <summary> Communication was acknowledged. </summary>
        public bool WasAcknowledged { get; }
    }
}
