// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Findings in a radiology report typically describe abnormalities, lesions, or other notable observations related to the anatomy or pathology of the imaged area. </summary>
    public partial class FindingInference : RadiologyInsightsInference
    {
        /// <summary> Initializes a new instance of <see cref="FindingInference"/>. </summary>
        /// <param name="finding"> Finding data : contains extensions, fields and components linked with the finding. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="finding"/> is null. </exception>
        internal FindingInference(FhirR4Observation finding)
        {
            Argument.AssertNotNull(finding, nameof(finding));

            Kind = RadiologyInsightsInferenceType.Finding;
            Finding = finding;
        }

        /// <summary> Initializes a new instance of <see cref="FindingInference"/>. </summary>
        /// <param name="kind"> Discriminator property for RadiologyInsightsInference. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="finding"> Finding data : contains extensions, fields and components linked with the finding. </param>
        internal FindingInference(RadiologyInsightsInferenceType kind, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, FhirR4Observation finding) : base(kind, extension, serializedAdditionalRawData)
        {
            Finding = finding;
        }

        /// <summary> Initializes a new instance of <see cref="FindingInference"/> for deserialization. </summary>
        internal FindingInference()
        {
        }

        /// <summary> Finding data : contains extensions, fields and components linked with the finding. </summary>
        public FhirR4Observation Finding { get; }
    }
}
