// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Resource is the ancestor of DomainResource from which most resources are derived. Bundle, Parameters, and Binary extend Resource directly.
    /// Based on [FHIR Resource](https://www.hl7.org/fhir/r4/resource.html
    /// </summary>
    public partial class FhirR4Resource
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Resource"/>. </summary>
        /// <param name="resourceType"> The type of resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceType"/> is null. </exception>
        public FhirR4Resource(string resourceType)
        {
            Argument.AssertNotNull(resourceType, nameof(resourceType));

            ResourceType = resourceType;
            AdditionalProperties = new ChangeTrackingDictionary<string, BinaryData>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Resource"/>. </summary>
        /// <param name="resourceType"> The type of resource. </param>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        internal FhirR4Resource(string resourceType, string id, FhirR4Meta meta, string implicitRules, string language, IDictionary<string, BinaryData> additionalProperties)
        {
            ResourceType = resourceType;
            Id = id;
            Meta = meta;
            ImplicitRules = implicitRules;
            Language = language;
            AdditionalProperties = additionalProperties;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Resource"/> for deserialization. </summary>
        internal FhirR4Resource()
        {
        }

        /// <summary> The type of resource. </summary>
        public string ResourceType { get; set; }
        /// <summary> Resource Id. </summary>
        public string Id { get; set; }
        /// <summary> Metadata about the resource. </summary>
        public FhirR4Meta Meta { get; set; }
        /// <summary> A set of rules under which this content was created. </summary>
        public string ImplicitRules { get; set; }
        /// <summary> Language of the resource content. </summary>
        public string Language { get; set; }
        /// <summary>
        /// Additional Properties
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> AdditionalProperties { get; }
    }
}
