// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Detailed information about Research Study
    /// Based on [FHIR ResearchStudy](https://www.hl7.org/fhir/R4/researchstudy.html)
    /// </summary>
    public partial class FhirR4ResearchStudy : FhirR4DomainResource
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4ResearchStudy"/>. </summary>
        /// <param name="status"> active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn. </param>
        internal FhirR4ResearchStudy(ResearchStudyStatusCodeType status) : base("ResearchStudy")
        {
            Identifier = new ChangeTrackingList<FhirR4Identifier>();
            Protocol = new ChangeTrackingList<FhirR4Reference>();
            PartOf = new ChangeTrackingList<FhirR4Reference>();
            Status = status;
            Category = new ChangeTrackingList<FhirR4CodeableConcept>();
            Focus = new ChangeTrackingList<FhirR4CodeableConcept>();
            Condition = new ChangeTrackingList<FhirR4CodeableConcept>();
            Contact = new ChangeTrackingList<FhirR4ContactDetail>();
            Keyword = new ChangeTrackingList<FhirR4CodeableConcept>();
            Location = new ChangeTrackingList<FhirR4CodeableConcept>();
            Enrollment = new ChangeTrackingList<FhirR4Reference>();
            Site = new ChangeTrackingList<FhirR4Reference>();
            Note = new ChangeTrackingList<FhirR4Annotation>();
            Arm = new ChangeTrackingList<ResearchStudyArm>();
            Objective = new ChangeTrackingList<ResearchStudyObjective>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4ResearchStudy"/>. </summary>
        /// <param name="resourceType"> The type of resource. </param>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="text"> Text summary of the resource, for human interpretation. </param>
        /// <param name="contained"> Contained, inline Resources. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="modifierExtension"> Extensions that cannot be ignored. </param>
        /// <param name="identifier"> Business Identifier for study. </param>
        /// <param name="title"> Name for this study. </param>
        /// <param name="protocol"> Steps followed in executing study. </param>
        /// <param name="partOf"> Part of larger study. </param>
        /// <param name="status"> active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn. </param>
        /// <param name="primaryPurposeType"> treatment | prevention | diagnostic | supportive-care | screening | health-services-research | basic-science | device-feasibility. </param>
        /// <param name="phase"> n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 | phase-3 | phase-4. </param>
        /// <param name="category"> Classifications for the study. </param>
        /// <param name="focus"> Drugs, devices, etc. under study. </param>
        /// <param name="condition"> Condition being studied. </param>
        /// <param name="contact"> Contact details for the study. </param>
        /// <param name="keyword"> Used to search for the study. </param>
        /// <param name="location"> Geographic region(s) for study. </param>
        /// <param name="description"> What this is study doing. </param>
        /// <param name="enrollment"> Inclusion &amp; exclusion criteria. </param>
        /// <param name="period"> When the study began and ended. </param>
        /// <param name="sponsor"> Organization that initiates and is legally responsible for the study. </param>
        /// <param name="principalInvestigator"> Researcher who oversees multiple aspects of the study. </param>
        /// <param name="site"> Facility where study activities are conducted. </param>
        /// <param name="reasonStopped"> accrual-goal-met | closed-due-to-toxicity | closed-due-to-lack-of-study-progress | temporarily-closed-per-study-design. </param>
        /// <param name="note"> Comments made about the study. </param>
        /// <param name="arm"> Defined path through the study for a subject. </param>
        /// <param name="objective"> A goal for the study. </param>
        internal FhirR4ResearchStudy(string resourceType, string id, FhirR4Meta meta, string implicitRules, string language, IDictionary<string, BinaryData> additionalProperties, FhirR4Narrative text, IReadOnlyList<FhirR4Resource> contained, IReadOnlyList<FhirR4Extension> extension, IReadOnlyList<FhirR4Extension> modifierExtension, IReadOnlyList<FhirR4Identifier> identifier, string title, IReadOnlyList<FhirR4Reference> protocol, IReadOnlyList<FhirR4Reference> partOf, ResearchStudyStatusCodeType status, FhirR4CodeableConcept primaryPurposeType, FhirR4CodeableConcept phase, IReadOnlyList<FhirR4CodeableConcept> category, IReadOnlyList<FhirR4CodeableConcept> focus, IReadOnlyList<FhirR4CodeableConcept> condition, IReadOnlyList<FhirR4ContactDetail> contact, IReadOnlyList<FhirR4CodeableConcept> keyword, IReadOnlyList<FhirR4CodeableConcept> location, string description, IReadOnlyList<FhirR4Reference> enrollment, FhirR4Period period, FhirR4Reference sponsor, FhirR4Reference principalInvestigator, IReadOnlyList<FhirR4Reference> site, FhirR4CodeableConcept reasonStopped, IReadOnlyList<FhirR4Annotation> note, IReadOnlyList<ResearchStudyArm> arm, IReadOnlyList<ResearchStudyObjective> objective) : base(resourceType, id, meta, implicitRules, language, additionalProperties, text, contained, extension, modifierExtension)
        {
            Identifier = identifier;
            Title = title;
            Protocol = protocol;
            PartOf = partOf;
            Status = status;
            PrimaryPurposeType = primaryPurposeType;
            Phase = phase;
            Category = category;
            Focus = focus;
            Condition = condition;
            Contact = contact;
            Keyword = keyword;
            Location = location;
            Description = description;
            Enrollment = enrollment;
            Period = period;
            Sponsor = sponsor;
            PrincipalInvestigator = principalInvestigator;
            Site = site;
            ReasonStopped = reasonStopped;
            Note = note;
            Arm = arm;
            Objective = objective;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4ResearchStudy"/> for deserialization. </summary>
        internal FhirR4ResearchStudy()
        {
        }

        /// <summary> Business Identifier for study. </summary>
        public IReadOnlyList<FhirR4Identifier> Identifier { get; }
        /// <summary> Name for this study. </summary>
        public string Title { get; }
        /// <summary> Steps followed in executing study. </summary>
        public IReadOnlyList<FhirR4Reference> Protocol { get; }
        /// <summary> Part of larger study. </summary>
        public IReadOnlyList<FhirR4Reference> PartOf { get; }
        /// <summary> active | administratively-completed | approved | closed-to-accrual | closed-to-accrual-and-intervention | completed | disapproved | in-review | temporarily-closed-to-accrual | temporarily-closed-to-accrual-and-intervention | withdrawn. </summary>
        public ResearchStudyStatusCodeType Status { get; }
        /// <summary> treatment | prevention | diagnostic | supportive-care | screening | health-services-research | basic-science | device-feasibility. </summary>
        public FhirR4CodeableConcept PrimaryPurposeType { get; }
        /// <summary> n-a | early-phase-1 | phase-1 | phase-1-phase-2 | phase-2 | phase-2-phase-3 | phase-3 | phase-4. </summary>
        public FhirR4CodeableConcept Phase { get; }
        /// <summary> Classifications for the study. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Category { get; }
        /// <summary> Drugs, devices, etc. under study. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Focus { get; }
        /// <summary> Condition being studied. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Condition { get; }
        /// <summary> Contact details for the study. </summary>
        public IReadOnlyList<FhirR4ContactDetail> Contact { get; }
        /// <summary> Used to search for the study. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Keyword { get; }
        /// <summary> Geographic region(s) for study. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Location { get; }
        /// <summary> What this is study doing. </summary>
        public string Description { get; }
        /// <summary> Inclusion &amp; exclusion criteria. </summary>
        public IReadOnlyList<FhirR4Reference> Enrollment { get; }
        /// <summary> When the study began and ended. </summary>
        public FhirR4Period Period { get; }
        /// <summary> Organization that initiates and is legally responsible for the study. </summary>
        public FhirR4Reference Sponsor { get; }
        /// <summary> Researcher who oversees multiple aspects of the study. </summary>
        public FhirR4Reference PrincipalInvestigator { get; }
        /// <summary> Facility where study activities are conducted. </summary>
        public IReadOnlyList<FhirR4Reference> Site { get; }
        /// <summary> accrual-goal-met | closed-due-to-toxicity | closed-due-to-lack-of-study-progress | temporarily-closed-per-study-design. </summary>
        public FhirR4CodeableConcept ReasonStopped { get; }
        /// <summary> Comments made about the study. </summary>
        public IReadOnlyList<FhirR4Annotation> Note { get; }
        /// <summary> Defined path through the study for a subject. </summary>
        public IReadOnlyList<ResearchStudyArm> Arm { get; }
        /// <summary> A goal for the study. </summary>
        public IReadOnlyList<ResearchStudyObjective> Objective { get; }
    }
}
