// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.RadiologyInsights
{
    public partial class FhirR4ResearchStudy : IUtf8JsonSerializable, IJsonModel<FhirR4ResearchStudy>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FhirR4ResearchStudy>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FhirR4ResearchStudy>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ResearchStudy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FhirR4ResearchStudy)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(Identifier))
            {
                writer.WritePropertyName("identifier"u8);
                writer.WriteStartArray();
                foreach (var item in Identifier)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsCollectionDefined(Protocol))
            {
                writer.WritePropertyName("protocol"u8);
                writer.WriteStartArray();
                foreach (var item in Protocol)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PartOf))
            {
                writer.WritePropertyName("partOf"u8);
                writer.WriteStartArray();
                foreach (var item in PartOf)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("status"u8);
            writer.WriteStringValue(Status.ToString());
            if (Optional.IsDefined(PrimaryPurposeType))
            {
                writer.WritePropertyName("primaryPurposeType"u8);
                writer.WriteObjectValue(PrimaryPurposeType, options);
            }
            if (Optional.IsDefined(Phase))
            {
                writer.WritePropertyName("phase"u8);
                writer.WriteObjectValue(Phase, options);
            }
            if (Optional.IsCollectionDefined(Category))
            {
                writer.WritePropertyName("category"u8);
                writer.WriteStartArray();
                foreach (var item in Category)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Focus))
            {
                writer.WritePropertyName("focus"u8);
                writer.WriteStartArray();
                foreach (var item in Focus)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Condition))
            {
                writer.WritePropertyName("condition"u8);
                writer.WriteStartArray();
                foreach (var item in Condition)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Contact))
            {
                writer.WritePropertyName("contact"u8);
                writer.WriteStartArray();
                foreach (var item in Contact)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Keyword))
            {
                writer.WritePropertyName("keyword"u8);
                writer.WriteStartArray();
                foreach (var item in Keyword)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStartArray();
                foreach (var item in Location)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsCollectionDefined(Enrollment))
            {
                writer.WritePropertyName("enrollment"u8);
                writer.WriteStartArray();
                foreach (var item in Enrollment)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Period))
            {
                writer.WritePropertyName("period"u8);
                writer.WriteObjectValue(Period, options);
            }
            if (Optional.IsDefined(Sponsor))
            {
                writer.WritePropertyName("sponsor"u8);
                writer.WriteObjectValue(Sponsor, options);
            }
            if (Optional.IsDefined(PrincipalInvestigator))
            {
                writer.WritePropertyName("principalInvestigator"u8);
                writer.WriteObjectValue(PrincipalInvestigator, options);
            }
            if (Optional.IsCollectionDefined(Site))
            {
                writer.WritePropertyName("site"u8);
                writer.WriteStartArray();
                foreach (var item in Site)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ReasonStopped))
            {
                writer.WritePropertyName("reasonStopped"u8);
                writer.WriteObjectValue(ReasonStopped, options);
            }
            if (Optional.IsCollectionDefined(Note))
            {
                writer.WritePropertyName("note"u8);
                writer.WriteStartArray();
                foreach (var item in Note)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Arm))
            {
                writer.WritePropertyName("arm"u8);
                writer.WriteStartArray();
                foreach (var item in Arm)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Objective))
            {
                writer.WritePropertyName("objective"u8);
                writer.WriteStartArray();
                foreach (var item in Objective)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                using (JsonDocument document = JsonDocument.Parse(item.Value))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
        }

        FhirR4ResearchStudy IJsonModel<FhirR4ResearchStudy>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ResearchStudy>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FhirR4ResearchStudy)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFhirR4ResearchStudy(document.RootElement, options);
        }

        internal static FhirR4ResearchStudy DeserializeFhirR4ResearchStudy(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<FhirR4Identifier> identifier = default;
            string title = default;
            IReadOnlyList<FhirR4Reference> protocol = default;
            IReadOnlyList<FhirR4Reference> partOf = default;
            ResearchStudyStatusCodeType status = default;
            FhirR4CodeableConcept primaryPurposeType = default;
            FhirR4CodeableConcept phase = default;
            IReadOnlyList<FhirR4CodeableConcept> category = default;
            IReadOnlyList<FhirR4CodeableConcept> focus = default;
            IReadOnlyList<FhirR4CodeableConcept> condition = default;
            IReadOnlyList<FhirR4ContactDetail> contact = default;
            IReadOnlyList<FhirR4CodeableConcept> keyword = default;
            IReadOnlyList<FhirR4CodeableConcept> location = default;
            string description = default;
            IReadOnlyList<FhirR4Reference> enrollment = default;
            FhirR4Period period = default;
            FhirR4Reference sponsor = default;
            FhirR4Reference principalInvestigator = default;
            IReadOnlyList<FhirR4Reference> site = default;
            FhirR4CodeableConcept reasonStopped = default;
            IReadOnlyList<FhirR4Annotation> note = default;
            IReadOnlyList<ResearchStudyArm> arm = default;
            IReadOnlyList<ResearchStudyObjective> objective = default;
            FhirR4Narrative text = default;
            IReadOnlyList<FhirR4Resource> contained = default;
            IReadOnlyList<FhirR4Extension> extension = default;
            IReadOnlyList<FhirR4Extension> modifierExtension = default;
            string resourceType = default;
            string id = default;
            FhirR4Meta meta = default;
            string implicitRules = default;
            string language = default;
            IDictionary<string, BinaryData> additionalProperties = default;
            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("identifier"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Identifier> array = new List<FhirR4Identifier>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Identifier.DeserializeFhirR4Identifier(item, options));
                    }
                    identifier = array;
                    continue;
                }
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("protocol"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Reference> array = new List<FhirR4Reference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Reference.DeserializeFhirR4Reference(item, options));
                    }
                    protocol = array;
                    continue;
                }
                if (property.NameEquals("partOf"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Reference> array = new List<FhirR4Reference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Reference.DeserializeFhirR4Reference(item, options));
                    }
                    partOf = array;
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = new ResearchStudyStatusCodeType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("primaryPurposeType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    primaryPurposeType = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("phase"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    phase = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    category = array;
                    continue;
                }
                if (property.NameEquals("focus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    focus = array;
                    continue;
                }
                if (property.NameEquals("condition"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    condition = array;
                    continue;
                }
                if (property.NameEquals("contact"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4ContactDetail> array = new List<FhirR4ContactDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4ContactDetail.DeserializeFhirR4ContactDetail(item, options));
                    }
                    contact = array;
                    continue;
                }
                if (property.NameEquals("keyword"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    keyword = array;
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    location = array;
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("enrollment"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Reference> array = new List<FhirR4Reference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Reference.DeserializeFhirR4Reference(item, options));
                    }
                    enrollment = array;
                    continue;
                }
                if (property.NameEquals("period"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    period = FhirR4Period.DeserializeFhirR4Period(property.Value, options);
                    continue;
                }
                if (property.NameEquals("sponsor"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sponsor = FhirR4Reference.DeserializeFhirR4Reference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("principalInvestigator"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    principalInvestigator = FhirR4Reference.DeserializeFhirR4Reference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("site"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Reference> array = new List<FhirR4Reference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Reference.DeserializeFhirR4Reference(item, options));
                    }
                    site = array;
                    continue;
                }
                if (property.NameEquals("reasonStopped"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reasonStopped = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("note"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Annotation> array = new List<FhirR4Annotation>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Annotation.DeserializeFhirR4Annotation(item, options));
                    }
                    note = array;
                    continue;
                }
                if (property.NameEquals("arm"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResearchStudyArm> array = new List<ResearchStudyArm>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResearchStudyArm.DeserializeResearchStudyArm(item, options));
                    }
                    arm = array;
                    continue;
                }
                if (property.NameEquals("objective"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResearchStudyObjective> array = new List<ResearchStudyObjective>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResearchStudyObjective.DeserializeResearchStudyObjective(item, options));
                    }
                    objective = array;
                    continue;
                }
                if (property.NameEquals("text"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    text = FhirR4Narrative.DeserializeFhirR4Narrative(property.Value, options);
                    continue;
                }
                if (property.NameEquals("contained"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Resource> array = new List<FhirR4Resource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeserializeFhirR4Resource(item, options));
                    }
                    contained = array;
                    continue;
                }
                if (property.NameEquals("extension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Extension> array = new List<FhirR4Extension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Extension.DeserializeFhirR4Extension(item, options));
                    }
                    extension = array;
                    continue;
                }
                if (property.NameEquals("modifierExtension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Extension> array = new List<FhirR4Extension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Extension.DeserializeFhirR4Extension(item, options));
                    }
                    modifierExtension = array;
                    continue;
                }
                if (property.NameEquals("resourceType"u8))
                {
                    resourceType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("meta"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    meta = FhirR4Meta.DeserializeFhirR4Meta(property.Value, options);
                    continue;
                }
                if (property.NameEquals("implicitRules"u8))
                {
                    implicitRules = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("language"u8))
                {
                    language = property.Value.GetString();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
            }
            additionalProperties = additionalPropertiesDictionary;
            return new FhirR4ResearchStudy(
                resourceType,
                id,
                meta,
                implicitRules,
                language,
                additionalProperties,
                text,
                contained ?? new ChangeTrackingList<FhirR4Resource>(),
                extension ?? new ChangeTrackingList<FhirR4Extension>(),
                modifierExtension ?? new ChangeTrackingList<FhirR4Extension>(),
                identifier ?? new ChangeTrackingList<FhirR4Identifier>(),
                title,
                protocol ?? new ChangeTrackingList<FhirR4Reference>(),
                partOf ?? new ChangeTrackingList<FhirR4Reference>(),
                status,
                primaryPurposeType,
                phase,
                category ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                focus ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                condition ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                contact ?? new ChangeTrackingList<FhirR4ContactDetail>(),
                keyword ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                location ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                description,
                enrollment ?? new ChangeTrackingList<FhirR4Reference>(),
                period,
                sponsor,
                principalInvestigator,
                site ?? new ChangeTrackingList<FhirR4Reference>(),
                reasonStopped,
                note ?? new ChangeTrackingList<FhirR4Annotation>(),
                arm ?? new ChangeTrackingList<ResearchStudyArm>(),
                objective ?? new ChangeTrackingList<ResearchStudyObjective>());
        }

        BinaryData IPersistableModel<FhirR4ResearchStudy>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ResearchStudy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FhirR4ResearchStudy)} does not support writing '{options.Format}' format.");
            }
        }

        FhirR4ResearchStudy IPersistableModel<FhirR4ResearchStudy>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ResearchStudy>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFhirR4ResearchStudy(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FhirR4ResearchStudy)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FhirR4ResearchStudy>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new FhirR4ResearchStudy FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFhirR4ResearchStudy(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
